/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.XmlHints;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.annotation.DisplayTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.XmlHintsAnnotation;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;

public class ExtensionFieldHandlerTestCase {
    private ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    @Test
    public void interfaceWithGetter() {
        ObjectType type = (ObjectType)this.typeLoader.load(HasGetter.class);
        Assert.assertThat((Object)type.getFields(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void xmlElementStyle() {
        ObjectType type = (ObjectType)this.typeLoader.load(NoRefType.class);
        Assert.assertThat((Object)type.getFields(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((ObjectFieldType)type.getFields().iterator().next()).getAnnotation(XmlHintsAnnotation.class).isPresent(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void flattenedField() {
        ObjectType type = (ObjectType)this.typeLoader.load(HasGroup.class);
        Assert.assertThat((Object)type.getFields().isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        ObjectFieldType field = type.getFields().stream().filter(f -> f.getKey().getName().getLocalPart().equals("group")).findFirst().get();
        Assert.assertThat((Object)field.getAnnotation(FlattenedTypeAnnotation.class).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)field.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ObjectType.class)));
    }

    @Test
    public void layoutField() {
        ObjectType type = (ObjectType)this.typeLoader.load(Group.class);
        Assert.assertThat((Object)type.getFields().isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        ObjectFieldType field = this.getField(type, "text");
        Assert.assertThat((Object)field.getAnnotation(LayoutTypeAnnotation.class).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((LayoutTypeAnnotation)field.getAnnotation(LayoutTypeAnnotation.class).get()).isText(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)field.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringType.class)));
        field = this.getField(type, "password");
        Assert.assertThat((Object)field.getAnnotation(LayoutTypeAnnotation.class).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((LayoutTypeAnnotation)field.getAnnotation(LayoutTypeAnnotation.class).get()).isPassword(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)field.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringType.class)));
        field = this.getField(type, "placement");
        Assert.assertThat((Object)field.getAnnotation(LayoutTypeAnnotation.class).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat(((LayoutTypeAnnotation)field.getAnnotation(LayoutTypeAnnotation.class).get()).getTabName().get(), (Matcher)CoreMatchers.is((Object)"tab"));
        Assert.assertThat(((LayoutTypeAnnotation)field.getAnnotation(LayoutTypeAnnotation.class).get()).getOrder().get(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat((Object)field.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberType.class)));
    }

    private ObjectFieldType getField(ObjectType type, String fieldName) {
        return type.getFields().stream().filter(f -> f.getKey().getName().getLocalPart().equals(fieldName)).findFirst().get();
    }

    @Test
    public void displayField() {
        ObjectType type = (ObjectType)this.typeLoader.load(DisplayField.class);
        Assert.assertThat((Object)type.getFields().isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        ObjectFieldType field = this.getField(type, "displayName");
        Assert.assertThat((Object)field.getAnnotation(DisplayTypeAnnotation.class).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((DisplayTypeAnnotation)field.getAnnotation(DisplayTypeAnnotation.class).get()).getDisplayName(), (Matcher)CoreMatchers.is((Object)"Display name"));
        Assert.assertThat((Object)field.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringType.class)));
        field = this.getField(type, "summary");
        Assert.assertThat((Object)((DisplayTypeAnnotation)field.getAnnotation(DisplayTypeAnnotation.class).get()).getSummary(), (Matcher)CoreMatchers.is((Object)"summary value"));
        Assert.assertThat((Object)field.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringType.class)));
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void invalidAnnotatedFields() {
        this.typeLoader.load(InvalidAnnotatedFields.class);
    }

    public class InvalidAnnotatedFields {
        @Optional
        private String notAParameter;
        @Expression(value=ExpressionSupport.NOT_SUPPORTED)
        private Object iSaidNotAParameterDoNotInsist;
    }

    public class Group {
        @Parameter
        @Text
        private String text;
        @Parameter
        @Password
        private String password;
        @Parameter
        @Placement(tab="tab", order=5)
        private Integer placement;
    }

    public class DisplayField {
        @Parameter
        @Summary(value="summary value")
        private String summary;
        @Parameter
        @DisplayName(value="Display name")
        private String displayName;
    }

    public class HasGroup {
        @ParameterGroup(name="group")
        private Group group;
    }

    public class NoRefType {
        @Parameter
        @XmlHints(allowReferences=false)
        private Object data;
    }

    static interface HasGetter {
        public String getSomeString();
    }
}

