/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.manifest;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.tck.TestHttpConnectorDeclarer;
import org.mule.runtime.extension.api.manifest.DescriberManifest;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;
import org.mule.runtime.extension.api.manifest.ExtensionManifestBuilder;
import org.mule.runtime.extension.tck.manifet.ExtensionManifestTestUtils;

public class ExtensionManifestBuilderTestCase {
    private ExtensionManifestBuilder builder;

    @Before
    public void before() {
        this.builder = ExtensionManifestTestUtils.getTestBuilder();
    }

    @Test
    public void build() {
        ExtensionManifest manifest = this.builder.build();
        Assert.assertThat((Object)manifest.getName(), (Matcher)CoreMatchers.is((Object)"http"));
        Assert.assertThat((Object)manifest.getDescription(), (Matcher)CoreMatchers.is((Object)"Http Connector"));
        Assert.assertThat((Object)manifest.getVersion(), (Matcher)CoreMatchers.is((Object)"1.0"));
        Assert.assertThat((Object)manifest.getMinMuleVersion(), (Matcher)CoreMatchers.is((Object)TestHttpConnectorDeclarer.MIN_MULE_VERSION));
        ExtensionManifestTestUtils.assertStringList(manifest.getExportedPackages(), ExtensionManifestTestUtils.EXPORTED_PACKAGES);
        ExtensionManifestTestUtils.assertStringList(manifest.getExportedResources(), ExtensionManifestTestUtils.EXPORTED_RESOURCES);
        DescriberManifest describerManifest = manifest.getDescriberManifest();
        Assert.assertThat((Object)describerManifest.getId(), (Matcher)CoreMatchers.is((Object)"annotations"));
        Assert.assertThat((Object)describerManifest.getProperties().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(describerManifest.getProperties().get("type"), (Matcher)CoreMatchers.is((Object)ExtensionManifestTestUtils.DESCRIBER_PROPERTY_VALUE));
    }

    @Test(expected=IllegalStateException.class)
    public void blankName() {
        this.builder.setName(null);
        this.builder.build();
    }

    @Test(expected=IllegalStateException.class)
    public void blankVersion() {
        this.builder.setVersion(null);
        this.builder.build();
    }

    @Test(expected=IllegalStateException.class)
    public void blankDescriberId() {
        this.builder.withDescriber().setId(null);
        this.builder.build();
    }
}

