/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.message.NullAttributes;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.tck.TestWebServiceConsumerDeclarer;
import org.mule.runtime.extension.api.declaration.type.ReconnectionStrategyTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.RedeliveryPolicyTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.StreamingStrategyTypeBuilder;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.internal.loader.BaseExtensionModelFactoryTestCase;

public class FlatExtensionModelFactoryTestCase
extends BaseExtensionModelFactoryTestCase {
    private static final MuleVersion MIN_MULE_VERSION = new MuleVersion("4.0");
    private final TestWebServiceConsumerDeclarer reference = new TestWebServiceConsumerDeclarer();
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void before() {
        this.declare(this::declareBase);
        this.load();
    }

    @Test
    public void assertExtension() {
        Assert.assertThat((Object)this.extensionModel.getName(), (Matcher)CoreMatchers.equalTo((Object)"WSConsumer"));
        Assert.assertThat((Object)this.extensionModel.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"Generic Consumer for SOAP Web Services"));
        Assert.assertThat((Object)this.extensionModel.getVersion(), (Matcher)CoreMatchers.equalTo((Object)"3.6.0"));
        Assert.assertThat((Object)this.extensionModel.getConfigurationModels(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.extensionModel.getVendor(), (Matcher)CoreMatchers.equalTo((Object)"MuleSoft"));
    }

    @Test
    public void defaultConfiguration() throws Exception {
        ConfigurationModel configurationModel = (ConfigurationModel)this.extensionModel.getConfigurationModel("config").get();
        Assert.assertThat((Object)configurationModel, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)configurationModel.getName(), (Matcher)CoreMatchers.equalTo((Object)"config"));
        Assert.assertThat((Object)configurationModel.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"Default description"));
        List parameterModels = configurationModel.getAllParameterModels();
        Assert.assertThat((Object)parameterModels, (Matcher)Matchers.hasSize((int)4));
        this.assertParameter((ParameterModel)parameterModels.get(0), "address", "Service address", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), StringType.class, null);
        this.assertParameter((ParameterModel)parameterModels.get(1), "port", "Service Port", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), StringType.class, null);
        this.assertParameter((ParameterModel)parameterModels.get(2), "service", "Service Name", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), StringType.class, null);
        this.assertParameter((ParameterModel)parameterModels.get(3), "wsdlLocation", "URI to find the WSDL", ExpressionSupport.NOT_SUPPORTED, true, this.typeLoader.load(String.class), StringType.class, null);
    }

    @Test
    public void onlyOneConfig() throws Exception {
        Assert.assertThat((Object)this.extensionModel.getConfigurationModels(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.extensionModel.getConfigurationModels().get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(this.extensionModel.getConfigurationModel("config").get())));
    }

    public void noSuchConfiguration() throws Exception {
        Assert.assertThat((Object)this.extensionModel.getConfigurationModel("fake").isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    public void noSuchOperation() throws Exception {
        Assert.assertThat((Object)this.extensionModel.getOperationModel("fake").isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void operations() throws Exception {
        List operationModels = this.extensionModel.getOperationModels();
        Assert.assertThat((Object)operationModels, (Matcher)Matchers.hasSize((int)3));
        this.assertConsumeOperation(operationModels);
        this.assertBroadcastOperation(operationModels);
        this.assertArglessOperation(operationModels);
    }

    @Test(expected=IllegalArgumentException.class)
    public void badExtensionVersion() {
        this.declare(declarer -> declarer.named("bad").onVersion("i'm new"));
        this.load();
    }

    @Test
    public void configurationsOrder() {
        String alpha = "alpha";
        String beta = "beta";
        String gamma = "gamma";
        this.declare(extensionDeclarer -> {
            extensionDeclarer.named("test").onVersion("1.0").fromVendor("MuleSoft").withCategory(Category.COMMUNITY).withMinMuleVersion(MIN_MULE_VERSION).withXmlDsl(XmlDslModel.builder().build());
            extensionDeclarer.withConfig("gamma").describedAs("gamma");
            extensionDeclarer.withConfig("beta").describedAs("beta");
            extensionDeclarer.withConfig("alpha").describedAs("alpha");
        });
        ExtensionModel extensionModel = this.load();
        List configurationModels = extensionModel.getConfigurationModels();
        Assert.assertThat((Object)configurationModels, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)((ConfigurationModel)configurationModels.get(0)).getName(), (Matcher)CoreMatchers.equalTo((Object)"alpha"));
        Assert.assertThat((Object)((ConfigurationModel)configurationModels.get(1)).getName(), (Matcher)CoreMatchers.equalTo((Object)"beta"));
        Assert.assertThat((Object)((ConfigurationModel)configurationModels.get(2)).getName(), (Matcher)CoreMatchers.equalTo((Object)"gamma"));
    }

    @Test
    public void operationsAlphaSorted() {
        Assert.assertThat((Object)this.extensionModel.getOperationModels(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)((OperationModel)this.extensionModel.getOperationModels().get(0)).getName(), (Matcher)CoreMatchers.equalTo((Object)"argLess"));
        Assert.assertThat((Object)((OperationModel)this.extensionModel.getOperationModels().get(1)).getName(), (Matcher)CoreMatchers.equalTo((Object)"broadcast"));
        Assert.assertThat((Object)((OperationModel)this.extensionModel.getOperationModels().get(2)).getName(), (Matcher)CoreMatchers.equalTo((Object)"consumer"));
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void nameClashes() {
        this.declare(extensionDeclarer -> this.reference.declareOn(extensionDeclarer).withConfig("config").describedAs(""));
        this.load();
    }

    @Test
    public void operationWithParameterNamedName() {
        this.exception.expect(IllegalModelDefinitionException.class);
        this.exception.expectMessage(CoreMatchers.containsString((String)"is named after a reserved one"));
        this.declare(extensionDeclarer -> {
            extensionDeclarer = this.declareBase((ExtensionDeclarer)extensionDeclarer);
            OperationDeclarer operation = (OperationDeclarer)extensionDeclarer.withOperation("invalidOperation").describedAs("");
            operation.onDefaultParameterGroup().withRequiredParameter("name").ofType(this.typeLoader.load(String.class));
            operation.withOutput().ofType(this.typeLoader.load(String.class));
            operation.withOutputAttributes().ofType(this.typeLoader.load(NullAttributes.class));
        });
        this.load();
    }

    @Test(expected=IllegalParameterModelDefinitionException.class)
    public void fixedParameterWithExpressionDefault() {
        this.declare(declarer -> {
            declarer = this.declareBase((ExtensionDeclarer)declarer);
            OperationDeclarer operation = (OperationDeclarer)declarer.withOperation("invalidOperation").describedAs("");
            operation.withOutput().ofType(this.typeLoader.load(String.class));
            operation.withOutputAttributes().ofType(this.typeLoader.load(NullAttributes.class));
            ((OptionalParameterDeclarer)((OptionalParameterDeclarer)operation.onDefaultParameterGroup().withOptionalParameter("fixed").ofType(this.typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo((Object)"#['hello']");
        });
        this.load();
    }

    public void operationWithParameterNamedTarget() {
        this.exception.expect(IllegalModelDefinitionException.class);
        this.exception.expectMessage(CoreMatchers.containsString((String)"The following operations have parameters named after reserved words"));
        this.declare(declarer -> {
            declarer = this.declareBase((ExtensionDeclarer)declarer);
            OperationDeclarer operation = (OperationDeclarer)declarer.withOperation("invalidOperation").describedAs("");
            operation.onDefaultParameterGroup().withOptionalParameter("target").ofType(this.typeLoader.load(String.class));
            operation.withOutput().ofType(this.typeLoader.load(String.class));
            operation.withOutputAttributes().ofType(this.typeLoader.load(NullAttributes.class));
        });
        this.load();
    }

    @Test(expected=IllegalParameterModelDefinitionException.class)
    public void expressionParameterWithFixedValue() {
        this.declare(declarer -> {
            declarer = this.declareBase((ExtensionDeclarer)declarer);
            OperationDeclarer operation = (OperationDeclarer)declarer.withOperation("invalidOperation").describedAs("");
            ((OptionalParameterDeclarer)((OptionalParameterDeclarer)operation.onDefaultParameterGroup().withOptionalParameter("expression").ofType(this.typeLoader.load(String.class))).withExpressionSupport(ExpressionSupport.REQUIRED)).defaultingTo((Object)"static");
            operation.withOutput().ofType(this.typeLoader.load(String.class));
            operation.withOutputAttributes().ofType(this.typeLoader.load(NullAttributes.class));
        });
        this.load();
    }

    @Test
    public void nullVendor() {
        this.expectIllegalModel("Extension Vendor cannot be null");
        this.declare(declarer -> this.declareBase((ExtensionDeclarer)declarer).fromVendor(null));
        this.load();
    }

    @Test
    public void nullCategory() {
        this.expectIllegalModel("Extension Category cannot be null");
        this.declare(declarer -> this.declareBase((ExtensionDeclarer)declarer).withCategory(null).fromVendor("SomeVendor").withMinMuleVersion(MIN_MULE_VERSION));
        this.load();
    }

    @Test
    public void nullMinMuleVersion() {
        this.expectIllegalModel("Extension Minimum Mule Version cannot be null");
        this.declare(declarer -> this.declareBase((ExtensionDeclarer)declarer).withMinMuleVersion(null).fromVendor("SomeVendor").withCategory(Category.COMMUNITY));
        this.load();
    }

    private void expectIllegalModel(String messageSubString) {
        this.exception.expect(IllegalModelDefinitionException.class);
        this.exception.expectMessage(CoreMatchers.containsString((String)messageSubString));
    }

    @Test
    public void configlessDescriptor() {
        this.declare(declarer -> declarer.named("noConfigs").onVersion("1.0").fromVendor("MuleSoft").withCategory(Category.COMMUNITY).withXmlDsl(XmlDslModel.builder().build()).withMinMuleVersion(MIN_MULE_VERSION));
        this.load();
    }

    @Test
    public void connectionProviders() {
        Assert.assertThat((Object)this.extensionModel.getConnectionProviders(), (Matcher)Matchers.hasSize((int)1));
        ConnectionProviderModel connectionProvider = (ConnectionProviderModel)this.extensionModel.getConnectionProviders().get(0);
        Assert.assertThat((Object)connectionProvider, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)connectionProvider.getName(), (Matcher)CoreMatchers.is((Object)"connectionProvider"));
        Assert.assertThat((Object)connectionProvider.getDescription(), (Matcher)CoreMatchers.is((Object)"my connection provider"));
        List parameters = connectionProvider.getAllParameterModels();
        this.assertParameter((ParameterModel)parameters.get(0), "reconnectionStrategy", "A retry strategy in case of connectivity errors", ExpressionSupport.NOT_SUPPORTED, false, new ReconnectionStrategyTypeBuilder().buildReconnectionStrategyType(), UnionType.class, null);
        this.assertParameter((ParameterModel)parameters.get(1), "username", "Authentication username", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), StringType.class, null);
        this.assertParameter((ParameterModel)parameters.get(2), "password", "Authentication password", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), StringType.class, null);
    }

    @Test
    public void messageSources() {
        Assert.assertThat((Object)this.extensionModel.getSourceModels(), (Matcher)Matchers.hasSize((int)1));
        SourceModel sourceModel = (SourceModel)this.extensionModel.getSourceModels().get(0);
        Assert.assertThat((Object)sourceModel, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)sourceModel.getName(), (Matcher)CoreMatchers.is((Object)"listener"));
        Assert.assertThat((Object)sourceModel.getDescription(), (Matcher)CoreMatchers.is((Object)"Listen requests"));
        Assert.assertThat((Object)JavaTypeUtils.getType((MetadataType)sourceModel.getOutput().getType()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(InputStream.class)));
        Assert.assertThat((Object)JavaTypeUtils.getType((MetadataType)sourceModel.getOutputAttributes().getType()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(Serializable.class)));
        List parameters = sourceModel.getAllParameterModels();
        this.assertParameter((ParameterModel)parameters.get(0), "redeliveryPolicy", "Defines a policy for processing the redelivery of the same message", ExpressionSupport.NOT_SUPPORTED, false, new RedeliveryPolicyTypeBuilder().buildRedeliveryPolicyType(), ObjectType.class, null);
        this.assertStreamingStrategyParameter((ParameterModel)parameters.get(1));
        this.assertParameter((ParameterModel)parameters.get(2), "url", "Url to listen on", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), StringType.class, null);
        this.assertParameter((ParameterModel)parameters.get(3), "port", "Port to listen on", ExpressionSupport.SUPPORTED, false, this.typeLoader.load(Integer.class), NumberType.class, 8080);
        this.assertParameter((ParameterModel)parameters.get(4), "reconnectionStrategy", "A retry strategy in case of connectivity errors", ExpressionSupport.NOT_SUPPORTED, false, new ReconnectionStrategyTypeBuilder().buildReconnectionStrategyType(), UnionType.class, null);
    }

    private void assertConsumeOperation(List<OperationModel> operationModels) {
        OperationModel operationModel = operationModels.get(2);
        Assert.assertThat((Object)operationModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(this.extensionModel.getOperationModel("consumer").get())));
        this.assertDataType(operationModel.getOutput().getType(), InputStream.class, BinaryType.class);
        Assert.assertThat((Object)operationModel.getName(), (Matcher)CoreMatchers.equalTo((Object)"consumer"));
        Assert.assertThat((Object)operationModel.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"Go get them tiger"));
        List parameterModels = operationModel.getAllParameterModels();
        Assert.assertThat((Object)parameterModels, (Matcher)Matchers.hasSize((int)4));
        this.assertStreamingStrategyParameter((ParameterModel)parameterModels.get(0));
        this.assertTargetParameter((ParameterModel)parameterModels.get(1));
        this.assertParameter((ParameterModel)parameterModels.get(2), "operation", "The operation to use", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), StringType.class, null);
        this.assertParameter((ParameterModel)parameterModels.get(3), "mtomEnabled", "Whether or not use MTOM for attachments", ExpressionSupport.SUPPORTED, false, this.typeLoader.load(Boolean.class), BooleanType.class, true);
    }

    private void assertBroadcastOperation(List<OperationModel> operationModels) {
        OperationModel operationModel = operationModels.get(1);
        Assert.assertThat((Object)operationModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(this.extensionModel.getOperationModel("broadcast").get())));
        this.assertDataType(operationModel.getOutput().getType(), Void.TYPE, VoidType.class);
        Assert.assertThat((Object)operationModel.getName(), (Matcher)CoreMatchers.equalTo((Object)"broadcast"));
        Assert.assertThat((Object)operationModel.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"consumes many services"));
        List parameterModels = operationModel.getAllParameterModels();
        Assert.assertThat((Object)parameterModels, (Matcher)Matchers.hasSize((int)3));
        ArrayTypeBuilder arrayTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType();
        arrayTypeBuilder.id(List.class.getName());
        arrayTypeBuilder.of((TypeBuilder)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().id(String.class.getTypeName()));
        ArrayType arrayType = arrayTypeBuilder.build();
        this.assertParameter((ParameterModel)parameterModels.get(0), "things", "The operation to use", ExpressionSupport.SUPPORTED, true, (MetadataType)arrayType, ArrayType.class, null);
        this.assertParameter((ParameterModel)parameterModels.get(1), "mtomEnabled", "Whether or not use MTOM for attachments", ExpressionSupport.SUPPORTED, false, this.typeLoader.load(Boolean.class), BooleanType.class, true);
        this.assertParameter((ParameterModel)parameterModels.get(2), "callback", "async callback", ExpressionSupport.REQUIRED, true, this.typeLoader.load(OperationModel.class), ObjectType.class, null);
    }

    private void assertTargetParameter(ParameterModel parameterModel) {
        this.assertParameter(parameterModel, "target", "The name of a variable on which the operation's output will be placed", ExpressionSupport.NOT_SUPPORTED, false, this.typeLoader.load(String.class), StringType.class, null);
    }

    private void assertStreamingStrategyParameter(ParameterModel parameter) {
        this.assertParameter(parameter, "streamingStrategy", "Configure if repeatable streams should be used and their behaviour", ExpressionSupport.NOT_SUPPORTED, false, new StreamingStrategyTypeBuilder().buildStreamingStrategyType(), UnionType.class, null);
    }

    private void assertArglessOperation(List<OperationModel> operationModels) {
        OperationModel operationModel = operationModels.get(0);
        Assert.assertThat((Object)operationModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(this.extensionModel.getOperationModel("argLess").get())));
        this.assertDataType(operationModel.getOutput().getType(), Integer.class, NumberType.class);
        Assert.assertThat((Object)operationModel.getName(), (Matcher)CoreMatchers.equalTo((Object)"argLess"));
        Assert.assertThat((Object)operationModel.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"has no args"));
        List parameterModels = operationModel.getAllParameterModels();
        Assert.assertThat((Object)parameterModels, (Matcher)Matchers.hasSize((int)1));
        this.assertTargetParameter((ParameterModel)parameterModels.get(0));
    }

    private ExtensionDeclarer declareBase(ExtensionDeclarer extensionDeclarer) {
        this.reference.declareOn(extensionDeclarer);
        return extensionDeclarer;
    }
}

