/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import java.lang.reflect.Type;
import java.util.List;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.java.api.handler.ObjectFieldHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.metadata.java.internal.handler.ObjectHandler;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Extensible;
import org.mule.runtime.extension.api.annotation.dsl.xml.XmlHints;
import org.mule.runtime.extension.api.declaration.type.annotation.ExtensibleTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterResolverTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.TypedValueTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.XmlHintsAnnotation;
import org.mule.runtime.extension.api.runtime.operation.ParameterResolver;

public class ExtensionObjectTypeHandler
extends ObjectHandler {
    private final ParameterResolverTypeAnnotation parameterResolverTypeAnnotation = new ParameterResolverTypeAnnotation();
    private final TypedValueTypeAnnotation typedValueTypeAnnotation = new TypedValueTypeAnnotation();

    public ExtensionObjectTypeHandler(ObjectFieldHandler fieldHandler) {
        super(fieldHandler);
    }

    public TypeBuilder<?> handleClass(Class<?> clazz, List<Type> genericTypes, TypeHandlerManager typeHandlerManager, ParsingContext context, BaseTypeBuilder baseTypeBuilder) {
        BaseTypeBuilder typeBuilder = baseTypeBuilder;
        Class<?> currentClass = clazz;
        if (ParameterResolver.class.isAssignableFrom(clazz)) {
            this.handleGenericType(clazz, genericTypes, typeHandlerManager, context, baseTypeBuilder, this.parameterResolverTypeAnnotation);
            currentClass = this.getGenericClass(genericTypes, 0);
        } else if (TypedValue.class.isAssignableFrom(clazz)) {
            this.handleGenericType(clazz, genericTypes, typeHandlerManager, context, baseTypeBuilder, this.typedValueTypeAnnotation);
            currentClass = this.getGenericClass(genericTypes, 0);
        } else {
            typeBuilder = super.handleClass(currentClass, genericTypes, typeHandlerManager, context, baseTypeBuilder);
        }
        if (typeBuilder != null && typeBuilder instanceof WithAnnotation) {
            XmlHints hints;
            if (currentClass.isAnnotationPresent(Extensible.class)) {
                ((WithAnnotation)typeBuilder).with((TypeAnnotation)new ExtensibleTypeAnnotation());
            }
            if ((hints = currentClass.getAnnotation(XmlHints.class)) != null) {
                ((WithAnnotation)typeBuilder).with((TypeAnnotation)new XmlHintsAnnotation(hints.allowInlineDefinition(), hints.allowTopLevelDefinition(), hints.allowReferences()));
            }
            Alias alias = currentClass.getAnnotation(Alias.class);
            ((WithAnnotation)typeBuilder).with((TypeAnnotation)new TypeAliasAnnotation(alias != null ? alias.value() : currentClass.getSimpleName()));
        }
        return typeBuilder;
    }

    private Class<?> getGenericClass(List<Type> genericTypes, int position) {
        Type type = genericTypes.get(position);
        return type instanceof Class ? (Class)type : Object.class;
    }

    private void handleGenericType(Class<?> clazz, List<Type> genericTypes, TypeHandlerManager typeHandlerManager, ParsingContext context, BaseTypeBuilder typeBuilder, TypeAnnotation annotation) {
        Preconditions.checkArgument((!genericTypes.isEmpty() ? 1 : 0) != 0, (String)String.format("Type %s doesn't have the required generic type", clazz));
        TypeBuilder handle = typeHandlerManager.handle(genericTypes.get(0), context, typeBuilder);
        if (handle instanceof WithAnnotation) {
            ((WithAnnotation)handle).with(annotation);
        }
    }
}

