/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.extension.api.declaration.type.annotation.XmlHintsAnnotation;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;

public final class XmlModelUtils {
    private static final String XSD_EXTENSION = ".xsd";
    private static final String CURRENT_VERSION = "current";
    public static final String DEFAULT_SCHEMA_LOCATION_MASK = "http://www.mulesoft.org/schema/mule/%s";
    public static final String MULE_NAMESPACE_SCHEMA_LOCATION = String.format("http://www.mulesoft.org/schema/mule/%s", "core");
    public static final String MULE_PREFIX = "mule";
    public static final QName MULE_ABSTRACT_REDELIVERY_POLICY_QNAME = new QName(MULE_NAMESPACE_SCHEMA_LOCATION, "abstract-redelivery-policy", "mule");
    public static final QName MULE_POOLING_PROFILE_TYPE_QNAME = new QName(MULE_NAMESPACE_SCHEMA_LOCATION, "pooling-profile", "mule");
    public static final QName MULE_ABSTRACT_RECONNECTION_STRATEGY_QNAME = new QName(MULE_NAMESPACE_SCHEMA_LOCATION, "abstract-reconnection-strategy", "mule");
    public static final QName MULE_ABSTRACT_STREAMING_STRATEGY_QNAME = new QName(MULE_NAMESPACE_SCHEMA_LOCATION, "abstract-streaming-strategy", "mule");

    public static XmlDslModel createXmlLanguageModel(Optional<String> prefix, Optional<String> namespace, String extensionName, String extensionVersion) {
        String stringPrefix = XmlModelUtils.isPresentAndNotBlank(prefix) ? prefix.get() : NameUtils.defaultNamespace(extensionName);
        String stringNamespace = XmlModelUtils.isPresentAndNotBlank(namespace) ? namespace.get() : XmlModelUtils.buildDefaultLocation(stringPrefix);
        return XmlModelUtils.getXmlDslModel(extensionVersion, stringPrefix, stringNamespace);
    }

    private static boolean isPresentAndNotBlank(Optional<String> element) {
        return element.isPresent() && StringUtils.isNotBlank((CharSequence)element.get());
    }

    private static XmlDslModel getXmlDslModel(String extensionVersion, String prefix, String namespace) {
        String xsdFileName = XmlModelUtils.buildDefaultXsdFileName(prefix);
        String schemaLocation = XmlModelUtils.buildDefaultSchemaLocation(namespace, xsdFileName);
        return XmlDslModel.builder().setSchemaVersion(extensionVersion).setPrefix(prefix).setNamespace(namespace).setSchemaLocation(schemaLocation).setXsdFileName(xsdFileName).build();
    }

    public static boolean supportsTopLevelDeclaration(MetadataType metadataType) {
        if (metadataType instanceof ObjectType && !ExtensionMetadataTypeUtils.isMap(metadataType)) {
            return metadataType.getAnnotation(XmlHintsAnnotation.class).map(XmlHintsAnnotation::allowsTopLevelDefinition).orElse(false);
        }
        return false;
    }

    private static String buildDefaultLocation(String namespace) {
        return String.format(DEFAULT_SCHEMA_LOCATION_MASK, namespace);
    }

    private static String buildDefaultXsdFileName(String namespace) {
        return String.format("mule-%s%s", namespace, XSD_EXTENSION);
    }

    private static String buildDefaultSchemaLocation(String namespaceLocation, String xsdFileName) {
        return String.format("%s/%s/%s", namespaceLocation, CURRENT_VERSION, xsdFileName);
    }
}

