/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;

public final class DefaultExtensionLoadingContext
implements ExtensionLoadingContext {
    private final ClassLoader extensionClassLoader;
    private final ExtensionDeclarer extensionDeclarer;
    private final List<ExtensionModelValidator> customValidators = new LinkedList<ExtensionModelValidator>();
    private final List<DeclarationEnricher> customDeclarationEnrichers = new LinkedList<DeclarationEnricher>();
    private final Map<String, Object> customParameters = new HashMap<String, Object>();

    public DefaultExtensionLoadingContext(ClassLoader extensionClassLoader) {
        this(new ExtensionDeclarer(), extensionClassLoader);
    }

    public DefaultExtensionLoadingContext(ExtensionDeclarer extensionDeclarer, ClassLoader extensionClassLoader) {
        Preconditions.checkArgument((extensionDeclarer != null ? 1 : 0) != 0, (String)"extension declarer cannot be null");
        Preconditions.checkArgument((extensionClassLoader != null ? 1 : 0) != 0, (String)"extension classLoader cannot be null");
        this.extensionDeclarer = extensionDeclarer;
        this.extensionClassLoader = extensionClassLoader;
    }

    @Override
    public ExtensionDeclarer getExtensionDeclarer() {
        return this.extensionDeclarer;
    }

    @Override
    public void addParameter(String key, Object value) {
        Preconditions.checkArgument((key != null && key.length() > 0 ? 1 : 0) != 0, (String)"key cannot be blank");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"value cannot be null");
        this.customParameters.put(key, value);
    }

    @Override
    public void addParameters(Map<String, Object> parameters) {
        Preconditions.checkArgument((parameters != null ? 1 : 0) != 0, (String)"cannot add null parameters");
        this.customParameters.putAll(parameters);
    }

    @Override
    public <T> Optional<T> getParameter(String key) {
        return Optional.ofNullable(this.customParameters.get(key));
    }

    @Override
    public ExtensionLoadingContext addCustomValidator(ExtensionModelValidator extensionModelValidator) {
        Preconditions.checkArgument((extensionModelValidator != null ? 1 : 0) != 0, (String)"custom validator cannot be null");
        this.customValidators.add(extensionModelValidator);
        return this;
    }

    @Override
    public ExtensionLoadingContext addCustomValidators(Collection<ExtensionModelValidator> extensionModelValidators) {
        Preconditions.checkArgument((extensionModelValidators != null ? 1 : 0) != 0, (String)"custom validators cannot be null");
        this.customValidators.addAll(extensionModelValidators);
        return this;
    }

    @Override
    public ExtensionLoadingContext addCustomDeclarationEnricher(DeclarationEnricher enricher) {
        Preconditions.checkArgument((enricher != null ? 1 : 0) != 0, (String)"custom enricher cannot be null");
        this.customDeclarationEnrichers.add(enricher);
        return this;
    }

    @Override
    public ExtensionLoadingContext addCustomDeclarationEnrichers(Collection<DeclarationEnricher> enrichers) {
        Preconditions.checkArgument((enrichers != null ? 1 : 0) != 0, (String)"custom enrichers cannot be null");
        this.customDeclarationEnrichers.addAll(enrichers);
        return this;
    }

    @Override
    public ClassLoader getExtensionClassLoader() {
        return this.extensionClassLoader;
    }

    @Override
    public List<DeclarationEnricher> getCustomDeclarationEnrichers() {
        return Collections.unmodifiableList(this.customDeclarationEnrichers);
    }

    @Override
    public List<ExtensionModelValidator> getCustomValidators() {
        return Collections.unmodifiableList(this.customValidators);
    }
}

