/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.io.InputStream;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ReconnectionStrategyTypeBuilder;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.mule.runtime.extension.internal.loader.enricher.InfrastructureDeclarationEnricher;
import org.mule.runtime.extension.internal.property.QNameModelProperty;

public class StreamingDeclarationEnricher
extends InfrastructureDeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new IdempotentDeclarationWalker(){

            @Override
            protected void onOperation(OperationDeclaration declaration) {
                StreamingDeclarationEnricher.this.enrich((ComponentDeclaration)declaration);
            }

            @Override
            protected void onSource(SourceDeclaration declaration) {
                StreamingDeclarationEnricher.this.enrich((ComponentDeclaration)declaration);
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private void enrich(ComponentDeclaration declaration) {
        if (InputStream.class.getName().equals(ExtensionMetadataTypeUtils.getId(declaration.getOutput().getType()))) {
            ParameterDeclaration parameter = new ParameterDeclaration("streamingStrategy");
            parameter.setDescription("Configure if repeatable streams should be used and their behaviour");
            parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
            parameter.setRequired(false);
            parameter.setParameterRole(ParameterRole.BEHAVIOUR);
            parameter.setType(new ReconnectionStrategyTypeBuilder().buildReconnectionStrategyType(), false);
            parameter.setLayoutModel(LayoutModel.builder().tabName("Streaming").build());
            parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
            parameter.addModelProperty((ModelProperty)new QNameModelProperty(XmlModelUtils.MULE_ABSTRACT_STREAMING_STRATEGY_QNAME));
            this.markAsInfrastructure(parameter);
            declaration.getParameterGroup("General").addParameter(parameter);
        }
    }
}

