/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;

public final class TransactionalDeclarationEnricher
implements DeclarationEnricher {
    private final MetadataType transactionalActionType;

    public TransactionalDeclarationEnricher() {
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        this.transactionalActionType = typeLoader.load(OperationTransactionalAction.class);
    }

    @Override
    public void enrich(final ExtensionLoadingContext extensionLoadingContext) {
        new IdempotentDeclarationWalker(){

            @Override
            protected void onOperation(OperationDeclaration declaration) {
                if (declaration.isTransactional()) {
                    declaration.getAllParameters().stream().filter(parameter -> "transactionalAction".equals(parameter.getName())).findAny().ifPresent(p -> {
                        throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' from extension '%s' defines a parameter named '%s' which is a reserved word", declaration.getName(), ((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration()).getName(), "transactionalAction"));
                    });
                    ParameterDeclaration transactionParameter = new ParameterDeclaration("transactionalAction");
                    transactionParameter.setType(TransactionalDeclarationEnricher.this.transactionalActionType, false);
                    transactionParameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
                    transactionParameter.setRequired(false);
                    transactionParameter.setDefaultValue((Object)OperationTransactionalAction.JOIN_IF_POSSIBLE);
                    transactionParameter.setDescription("The type of joining action that operations can take regarding transactions.");
                    transactionParameter.setLayoutModel(LayoutModel.builder().tabName("Transactions").build());
                    declaration.getParameterGroup("General").addParameter(transactionParameter);
                }
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }
}

