/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.extension.api.declaration.type.annotation.XmlHintsAnnotation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.SingleExtensionImportTypesStrategy;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;

public final class ParameterModelValidator
implements ExtensionModelValidator {
    private TypeCatalog typeCatalog;
    private DslSyntaxResolver dsl;

    @Override
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        this.typeCatalog = TypeCatalog.getDefault(Collections.singleton(extensionModel));
        this.dsl = DslSyntaxResolver.getDefault(extensionModel, new SingleExtensionImportTypesStrategy());
        new ExtensionWalker(){

            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                String ownerName = owner.getName();
                String ownerModelType = NameUtils.getComponentModelTypeName(owner);
                ParameterModelValidator.this.validateParameter(model, ownerName, ownerModelType, problemsReporter);
                ParameterModelValidator.this.validateNameCollisionWithTypes(model, ownerName, ownerModelType, owner.getAllParameterModels().stream().map(p -> NameUtils.hyphenize(p.getName())).collect(Collectors.toList()), problemsReporter);
            }
        }.walk(extensionModel);
    }

    private void validateParameter(final ParameterModel parameterModel, String ownerName, String ownerModelType, ProblemsReporter problemsReporter) {
        if (ParameterModel.RESERVED_NAMES.contains(parameterModel.getName())) {
            problemsReporter.addError(new Problem((NamedObject)parameterModel, String.format("Parameter '%s' in the %s '%s' is named after a reserved one", parameterModel.getName(), ownerModelType, ownerName)));
        }
        if (parameterModel.getType() == null) {
            problemsReporter.addError(new Problem((NamedObject)parameterModel, String.format("Parameter '%s' in the %s '%s' must provide a type", parameterModel.getName(), ownerModelType, ownerName)));
        }
        if (parameterModel.isRequired() && parameterModel.getDefaultValue() != null) {
            problemsReporter.addError(new Problem((NamedObject)parameterModel, String.format("Parameter '%s' in the %s '%s' is required, and must not provide a default value", parameterModel.getName(), ownerModelType, ownerName)));
        }
        if (parameterModel.getType() == null) {
            problemsReporter.addError(new Problem((NamedObject)parameterModel, String.format("Parameter '%s' in the %s '%s' doesn't specify a return type", parameterModel.getName(), ownerModelType, ownerName)));
        } else {
            parameterModel.getType().accept(new MetadataTypeVisitor(){
                private Set<MetadataType> visitedTypes = new HashSet<MetadataType>();

                public void visitArrayType(ArrayType arrayType) {
                    arrayType.getType().accept((MetadataTypeVisitor)this);
                }

                public void visitObject(ObjectType objectType) {
                    DslElementSyntax paramDsl = ParameterModelValidator.this.dsl.resolve(parameterModel);
                    if (objectType.isOpen()) {
                        ((MetadataType)objectType.getOpenRestriction().get()).accept((MetadataTypeVisitor)this);
                    } else if ((paramDsl.supportsTopLevelDeclaration() || paramDsl.supportsChildDeclaration()) && this.visitedTypes.add((MetadataType)objectType)) {
                        for (ObjectFieldType field : objectType.getFields()) {
                            String fieldName = field.getKey().getName().getLocalPart();
                            if (ParameterModel.RESERVED_NAMES.contains(fieldName)) {
                                throw new IllegalParameterModelDefinitionException(String.format("The field named '%s' [%s] from class [%s] cannot have that name since it is a reserved one", fieldName, ExtensionMetadataTypeUtils.getId(field.getValue()), ExtensionMetadataTypeUtils.getId((MetadataType)objectType)));
                            }
                            if (!ParameterModelValidator.this.supportsGlobalReferences(field)) continue;
                            field.getValue().accept((MetadataTypeVisitor)this);
                        }
                    }
                }
            });
            this.validateParameterIsPlural(parameterModel, ownerModelType, ownerName, problemsReporter);
        }
    }

    private void validateParameterIsPlural(final ParameterModel parameterModel, final String ownerModelType, final String ownerName, final ProblemsReporter problemsReporter) {
        parameterModel.getType().accept(new MetadataTypeVisitor(){

            public void visitArrayType(ArrayType arrayType) {
                if (parameterModel.getName().equals(NameUtils.singularize(parameterModel.getName()))) {
                    problemsReporter.addError(new Problem((NamedObject)parameterModel, String.format("Parameter '%s' in the %s '%s' is a collection and its name should be plural", parameterModel.getName(), ownerModelType, ownerName)));
                }
            }
        });
    }

    private void validateNameCollisionWithTypes(ParameterModel parameterModel, String ownerName, String ownerModelType, List<String> parameterNames, ProblemsReporter problemsReporter) {
        if (parameterModel.getType() instanceof ObjectType) {
            this.typeCatalog.getSubTypes((ObjectType)parameterModel.getType()).stream().filter(subtype -> parameterNames.contains(NameUtils.getTopLevelTypeName((MetadataType)subtype))).findFirst().ifPresent(metadataType -> problemsReporter.addError(new Problem((NamedObject)parameterModel, String.format("Parameter '%s' in the %s [%s] can't have the same name as the ClassName or Alias of the declared subType [%s] for parameter [%s]", NameUtils.getTopLevelTypeName((MetadataType)metadataType), ownerModelType, ownerName, JavaTypeUtils.getType((MetadataType)metadataType).getSimpleName(), parameterModel.getName()))));
        }
    }

    private boolean supportsGlobalReferences(ObjectFieldType field) {
        return this.dsl.resolve(field.getValue()).map(DslElementSyntax::supportsTopLevelDeclaration).orElseGet(() -> field.getAnnotation(XmlHintsAnnotation.class).map(XmlHintsAnnotation::allowsReferences).orElse(true));
    }
}

