/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.introspection;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.extension.introspection.DataQualifier;
import org.mule.extension.introspection.DataQualifierFactory;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Operation;
import org.mule.extension.introspection.declaration.fluent.Declaration;

public class DataQualifierFactoryTestCase {
    @Test
    public void bool() {
        this.doAssert(DataQualifier.BOOLEAN, Boolean.TYPE, Boolean.class);
    }

    @Test
    public void string() {
        this.doAssert(DataQualifier.STRING, String.class, Character.TYPE, Character.class);
    }

    @Test
    public void integer() {
        this.doAssert(DataQualifier.INTEGER, Integer.TYPE, Short.TYPE, Integer.class, Short.class);
    }

    @Test
    public void doubleQualifier() {
        this.doAssert(DataQualifier.DOUBLE, Double.TYPE, Float.TYPE, Double.class, Float.class);
    }

    @Test
    public void longQualifier() {
        this.doAssert(DataQualifier.LONG, Long.TYPE, Long.class);
    }

    @Test
    public void decimal() {
        this.doAssert(DataQualifier.DECIMAL, BigDecimal.class, BigInteger.class);
    }

    @Test
    public void dateTime() {
        this.doAssert(DataQualifier.DATE_TIME, Time.class, Timestamp.class, Calendar.class, XMLGregorianCalendar.class);
    }

    @Test
    public void enumQualifier() {
        this.doAssert(DataQualifier.ENUM, Enumeration.class, Enum.class, DataQualifier.class);
    }

    @Test
    public void list() {
        this.doAssert(DataQualifier.LIST, List.class, Set.class, Object[].class);
    }

    @Test
    public void map() {
        this.doAssert(DataQualifier.MAP, Map.class);
    }

    @Test
    public void operation() {
        this.doAssert(DataQualifier.OPERATION, Operation.class);
    }

    @Test
    public void bean() {
        this.doAssert(DataQualifier.POJO, Extension.class, Declaration.class, Object.class);
    }

    private void doAssert(DataQualifier expected, Class<?> ... types) {
        for (Class<?> type : types) {
            DataQualifier evaluated = DataQualifierFactory.getQualifier(type);
            Assert.assertThat((String)String.format("was expecting %s but type %s returned %s instead", expected, type.getName(), evaluated), (Object)evaluated, (Matcher)CoreMatchers.equalTo((Object)expected));
        }
    }
}

