/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.introspection.declaration;

import java.util.Date;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.extension.introspection.declaration.fluent.CapableDeclaration;

public abstract class CapableDeclarationContractTestCase<T extends CapableDeclaration> {
    private static final Object testCapability1 = new Object();
    private static final Object testCapability2 = "hello";
    protected T declaration;

    @Before
    public void before() {
        this.declaration = this.createDeclaration();
    }

    protected abstract T createDeclaration();

    @Test
    public void getCapabilities() {
        this.addCapabilities();
        Set capabilities = this.declaration.getCapabilities();
        Assert.assertThat((Object)capabilities.contains(testCapability1), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)capabilities.contains(testCapability2), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void capabilitiesAreImmutable() {
        this.declaration.getCapabilities().add(new Object());
    }

    @Test
    public void getCapabilitiesByType() {
        this.addCapabilities();
        Set matchingCapabilities = this.declaration.getCapabilities(String.class);
        Assert.assertThat((Object)matchingCapabilities, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)matchingCapabilities, (Matcher)Matchers.contains((Object[])new Object[]{testCapability2}));
    }

    @Test
    public void isCapableOf() {
        this.addCapabilities();
        Assert.assertThat((Object)this.declaration.isCapableOf(String.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.declaration.isCapableOf(Date.class), (Matcher)CoreMatchers.is((Object)false));
    }

    private void addCapabilities() {
        this.declaration.addCapability(testCapability1);
        this.declaration.addCapability(testCapability2);
    }
}

