/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.introspection.declaration;

import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.extension.introspection.DataQualifier;
import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.Operation;
import org.mule.extension.introspection.declaration.CapableDeclarationContractTestCase;
import org.mule.extension.introspection.declaration.fluent.ConfigurationDeclaration;
import org.mule.extension.introspection.declaration.fluent.Declaration;
import org.mule.extension.introspection.declaration.fluent.OperationDeclaration;
import org.mule.extension.introspection.declaration.fluent.ParameterDeclaration;
import org.mule.extension.introspection.declaration.tck.TestWebServiceConsumerDeclarationReference;

@RunWith(value=MockitoJUnitRunner.class)
public class DeclarationTestCase
extends CapableDeclarationContractTestCase<Declaration> {
    private TestWebServiceConsumerDeclarationReference testDeclaration;

    @Override
    @Before
    public void before() {
        this.testDeclaration = new TestWebServiceConsumerDeclarationReference();
        this.declaration = this.createDeclaration();
    }

    @Override
    protected Declaration createDeclaration() {
        return this.testDeclaration.getDescriptor().getRootDeclaration().getDeclaration();
    }

    @Test
    public void assertDeclaration() {
        Assert.assertThat((Object)((Declaration)this.declaration).getName(), (Matcher)CoreMatchers.is((Object)"WSConsumer"));
        Assert.assertThat((Object)((Declaration)this.declaration).getDescription(), (Matcher)CoreMatchers.is((Object)"Generic Consumer for SOAP Web Services"));
        Assert.assertThat((Object)((Declaration)this.declaration).getVersion(), (Matcher)CoreMatchers.is((Object)"3.6.0"));
        Assert.assertThat((Object)((Declaration)this.declaration).getConfigurations(), (Matcher)Matchers.hasSize((int)1));
        Set capabilities = ((Declaration)this.declaration).getCapabilities();
        Assert.assertThat((Object)capabilities, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)capabilities, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)capabilities, (Matcher)Matchers.contains((Object[])new Object[]{this.testDeclaration.getCapability()}));
    }

    @Test
    public void defaultConfiguration() throws Exception {
        Assert.assertThat((Object)((Declaration)this.declaration).getConfigurations(), (Matcher)Matchers.hasSize((int)1));
        ConfigurationDeclaration configuration = (ConfigurationDeclaration)((Declaration)this.declaration).getConfigurations().get(0);
        Assert.assertThat((Object)configuration, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)configuration.getConfigurationInstantiator(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.testDeclaration.getConfigurationInstantiator())));
        Assert.assertThat((Object)configuration.getName(), (Matcher)CoreMatchers.is((Object)"config"));
        Assert.assertThat((Object)configuration.getDescription(), (Matcher)CoreMatchers.is((Object)"Default description"));
        List parameters = configuration.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)4));
        this.assertParameter((ParameterDeclaration)parameters.get(0), "wsdlLocation", "URI to find the WSDL", false, true, DataType.of(String.class), DataQualifier.STRING, null);
        this.assertParameter((ParameterDeclaration)parameters.get(1), "service", "Service Name", true, true, DataType.of(String.class), DataQualifier.STRING, null);
        this.assertParameter((ParameterDeclaration)parameters.get(2), "port", "Service Port", true, true, DataType.of(String.class), DataQualifier.STRING, null);
        this.assertParameter((ParameterDeclaration)parameters.get(3), "address", "Service address", true, true, DataType.of(String.class), DataQualifier.STRING, null);
        Assert.assertThat((Object)((ParameterDeclaration)parameters.get(2)).getCapabilities(), (Matcher)Matchers.contains((Object[])new Object[]{this.testDeclaration.getCapability()}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullCapability() {
        this.testDeclaration.getDescriptor().withCapability(null);
    }

    @Test
    public void operations() throws Exception {
        List operations = ((Declaration)this.declaration).getOperations();
        Assert.assertThat((Object)operations, (Matcher)Matchers.hasSize((int)3));
        this.assertConsumeOperation(operations);
        this.assertBroadcastOperation(operations);
        this.assertArgLessOperation(operations);
    }

    private void assertConsumeOperation(List<OperationDeclaration> operations) {
        OperationDeclaration operation = operations.get(0);
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)"consumer"));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.is((Object)"Go get them tiger"));
        Assert.assertThat((Object)operation.getExecutorFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.testDeclaration.getConsumerExecutorFactory())));
        Assert.assertThat((Object)operation.getCapabilities(), (Matcher)Matchers.contains((Object[])new Object[]{this.testDeclaration.getCapability()}));
        List parameters = operation.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)2));
        this.assertParameter((ParameterDeclaration)parameters.get(0), "operation", "The operation to use", true, true, DataType.of(String.class), DataQualifier.STRING, null);
        this.assertParameter((ParameterDeclaration)parameters.get(1), "mtomEnabled", "Whether or not use MTOM for attachments", true, false, DataType.of(Boolean.class), DataQualifier.BOOLEAN, true);
        Assert.assertThat((Object)((ParameterDeclaration)parameters.get(0)).getCapabilities(), (Matcher)Matchers.contains((Object[])new Object[]{this.testDeclaration.getCapability()}));
    }

    private void assertBroadcastOperation(List<OperationDeclaration> operations) {
        OperationDeclaration operation = operations.get(1);
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)"broadcast"));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.is((Object)"consumes many services"));
        Assert.assertThat((Object)operation.getExecutorFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.testDeclaration.getBroadcastExecutorFactory())));
        List parameters = operation.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)3));
        this.assertParameter((ParameterDeclaration)parameters.get(0), "operation", "The operation to use", true, true, DataType.of(List.class, (Class[])new Class[]{String.class}), DataQualifier.LIST, null);
        this.assertParameter((ParameterDeclaration)parameters.get(1), "mtomEnabled", "Whether or not use MTOM for attachments", true, false, DataType.of(Boolean.class), DataQualifier.BOOLEAN, true);
        this.assertParameter((ParameterDeclaration)parameters.get(2), "callback", "async callback", false, true, DataType.of(Operation.class), DataQualifier.OPERATION, null);
    }

    private void assertArgLessOperation(List<OperationDeclaration> operations) {
        OperationDeclaration operation = operations.get(2);
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)"argLess"));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.is((Object)"has no args"));
        List parameters = operation.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)parameters.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void assertParameter(ParameterDeclaration parameter, String name, String description, boolean acceptsExpressions, boolean required, DataType type, DataQualifier qualifier, Object defaultValue) {
        Assert.assertThat((Object)parameter, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)name));
        Assert.assertThat((Object)parameter.getDescription(), (Matcher)CoreMatchers.is((Object)description));
        Assert.assertThat((Object)parameter.isDynamic(), (Matcher)CoreMatchers.is((Object)acceptsExpressions));
        Assert.assertThat((Object)parameter.isRequired(), (Matcher)CoreMatchers.is((Object)required));
        Assert.assertThat((Object)parameter.getDefaultValue(), (Matcher)CoreMatchers.equalTo((Object)defaultValue));
        Assert.assertThat((Object)parameter.getType(), (Matcher)CoreMatchers.equalTo((Object)type));
        junit.framework.Assert.assertSame((Object)qualifier, (Object)parameter.getType().getQualifier());
    }
}

