/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.extension.maven;

import org.mule.plugin.maven.AbstractPackagePluginMojo;
import org.mule.plugin.maven.ModuleArchiver;
import org.mule.plugin.maven.PluginProperties;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;


/**
 * Build a Mule extension archive.
 */
@Mojo(name = "package", defaultPhase = LifecyclePhase.PACKAGE, requiresDependencyResolution = ResolutionScope.RUNTIME)
public class ExtensionPackageMojo extends AbstractPackagePluginMojo
{

    private ExtensionMojoUtils extensionMojoUtils;

    @Override
    public void initialize() throws MojoFailureException
    {
        extensionMojoUtils = new ExtensionMojoUtils(outputDirectory, finalName);
    }

    @Override
    protected void addToArchiver(ModuleArchiver archiver) throws MojoFailureException
    {
        addConnectorJar(archiver);
        super.addToArchiver(archiver);
    }

    @Override
    protected void doAddPluginProperties(File pluginPropertiesFile) throws MojoFailureException
    {
        final ExtensionManifest manifest = extensionMojoUtils.getExtensionManifest();

        PluginProperties properties = new PluginProperties();
        properties.addExportedPackages(manifest.getExportedPackages());
        properties.addExportedResources(manifest.getExportedResources());

        try (OutputStream out = new FileOutputStream(pluginPropertiesFile))
        {
            properties.writeTo(out);
        }
        catch (IOException e)
        {
            throw new MojoFailureException("Error writing properties file ", e);
        }
    }

    private void addConnectorJar(ModuleArchiver archiver) throws MojoFailureException
    {
        final File jar = extensionMojoUtils.getExtensionJar();
        getLog().info(String.format("Adding extension jar <%1s>", jar.getName()));
        archiver.addLib(jar);
    }
}
