/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.extension.maven.generator;

import static javax.xml.transform.OutputKeys.INDENT;
import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.apache.commons.lang3.StringUtils.lowerCase;

import java.io.File;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * Generator for 'category.xml' file.
 * The 'category.xml' file selects features for the p2 repository and specifies how to categorize them in the UpdateSite
 *
 * @since 1.0
 */
public class StudioSiteXmlGenerator
{

    private static final String CATEGORY_XML = "category.xml";

    private final MavenProject project;
    private final GenerationContext context;

    public StudioSiteXmlGenerator(GenerationContext context)
    {

        this.project = context.getMavenProject();
        this.context = context;
    }

    public void generate() throws MojoFailureException
    {
        try
        {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

            Element site = document.createElement("site");
            document.appendChild(site);

            Element feature = document.createElement("feature");
            feature.setAttribute("id", context.getFeatureId());

            Element categoryElement = document.createElement("category");
            categoryElement.setAttribute("name", project.getGroupId());
            feature.appendChild(categoryElement);

            Element categoryDef = document.createElement("category-def");
            categoryDef.setAttribute("name", project.getGroupId());
            categoryDef.setAttribute("label", capitalize(lowerCase(context.getExtensionCategory().name())));
            site.appendChild(feature);
            site.appendChild(categoryDef);

            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty(INDENT, "yes");

            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(context.getOutputDirectory(), CATEGORY_XML));
            transformer.transform(source, result);
        }
        catch (TransformerException | ParserConfigurationException e)
        {
            throw new MojoFailureException("Error happened generating 'category.xml' file", e);
        }
    }
}
