/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.generator;

import java.io.File;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.mule.extension.maven.generator.GenerationContext;

public class StudioPluginZipGenerator {
    private static final String STUDIO_PLUGIN = "studio-plugin";
    private final GenerationContext context;
    private final MavenProjectHelper projectHelper;

    public StudioPluginZipGenerator(GenerationContext context, MavenProjectHelper projectHelper) {
        this.context = context;
        this.projectHelper = projectHelper;
    }

    public void generate() throws MojoFailureException {
        try {
            ZipArchiver zipArchiver = new ZipArchiver();
            zipArchiver.addDirectory(new File(this.context.getOutputDirectory(), "update-site"));
            File updateSiteZipFile = new File(this.context.getOutputDirectory(), this.context.getArtifactName() + "-" + STUDIO_PLUGIN + ".zip");
            zipArchiver.setDestFile(updateSiteZipFile);
            zipArchiver.createArchive();
            this.projectHelper.attachArtifact(this.context.getMavenProject(), "zip", STUDIO_PLUGIN, updateSiteZipFile);
        }
        catch (Exception e) {
            throw new MojoFailureException("An error occurred packaging the extension Update Site", (Throwable)e);
        }
    }
}

