/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.extension.maven.ExtensionMojoUtils;
import org.mule.plugin.maven.AbstractPackagePluginMojo;
import org.mule.plugin.maven.ModuleArchiver;
import org.mule.plugin.maven.PluginProperties;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ExtensionPackageMojo
extends AbstractPackagePluginMojo {
    private static final String MULE_EXTENSION_TYPE = "mule-extension";
    private ExtensionMojoUtils extensionMojoUtils;

    public void initialize() throws MojoFailureException {
        this.extensionMojoUtils = new ExtensionMojoUtils(this.outputDirectory, this.finalName);
    }

    protected void addToArchiver(ModuleArchiver archiver) throws MojoFailureException {
        this.addConnectorJar(archiver);
        super.addToArchiver(archiver);
    }

    protected void doAddPluginProperties(File pluginPropertiesFile) throws MojoFailureException {
        ExtensionManifest manifest = this.extensionMojoUtils.getExtensionManifest();
        PluginProperties properties = new PluginProperties();
        properties.addExportedPackages(manifest.getExportedPackages());
        properties.addExportedResources(manifest.getExportedResources());
        properties.addPluginDependencies(this.getPluginDependencies());
        try (FileOutputStream out = new FileOutputStream(pluginPropertiesFile);){
            properties.writeTo((OutputStream)out);
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing properties file ", (Throwable)e);
        }
    }

    private Set<String> getPluginDependencies() {
        LinkedList fromProperty = new LinkedList();
        String pluginDependencies = this.project.getProperties().getProperty("pluginDependencies");
        if (pluginDependencies != null) {
            fromProperty.addAll(Arrays.stream(pluginDependencies.split(",")).map(String::trim).collect(Collectors.toList()));
        }
        List dependencies = this.project.getDependencies();
        List fromDependencies = dependencies.stream().filter(d -> d.getType().equals(MULE_EXTENSION_TYPE)).map(Dependency::getArtifactId).collect(Collectors.toList());
        return ImmutableSet.builder().addAll(fromProperty).addAll(fromDependencies).build();
    }

    private void addConnectorJar(ModuleArchiver archiver) throws MojoFailureException {
        File jar = this.extensionMojoUtils.getExtensionJar();
        this.getLog().info((CharSequence)String.format("Adding extension jar <%1s>", jar.getName()));
        archiver.addLib(jar);
    }
}

