/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;
import org.mule.extension.maven.ExtensionMojoUtils;
import org.mule.extension.maven.generator.ComponentSigner;
import org.mule.extension.maven.generator.FeatureJarGenerator;
import org.mule.extension.maven.generator.FeaturesAndBundlesGenerator;
import org.mule.extension.maven.generator.GenerationContext;
import org.mule.extension.maven.generator.PluginJarGenerator;
import org.mule.extension.maven.generator.StudioEditorsGenerator;
import org.mule.extension.maven.generator.StudioFeatureGenerator;
import org.mule.extension.maven.generator.StudioIconsGenerator;
import org.mule.extension.maven.generator.StudioManifestGenerator;
import org.mule.extension.maven.generator.StudioPluginXmlGenerator;
import org.mule.extension.maven.generator.StudioPluginZipGenerator;
import org.mule.extension.maven.generator.StudioSiteXmlGenerator;
import org.mule.plugin.maven.AbstractMuleMojo;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;

@Mojo(name="studio-package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ExtensionStudioPackageMojo
extends AbstractMuleMojo {
    private static final String EXTENSION_MODEL_JSON = "extension-model.json";
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(property="skipStudioPackage", defaultValue="${skip.studio.package}")
    private boolean skipStudioPackage;
    @Parameter(property="signExtension", defaultValue="${signExtension}")
    private boolean signExtension;
    @Parameter(property="keystorePath", defaultValue="${keystorePath}")
    private String keystorePath;
    @Parameter(property="alias", defaultValue="${alias}")
    private String alias;
    @Parameter(property="storepass", defaultValue="${storepass}")
    private String storepass;
    @Parameter(property="keypass", defaultValue="${keypass}")
    private String keypass;
    @Parameter(property="tsaUrl", defaultValue="${tsaUrl}")
    private String tsaUrl;
    @Component
    private P2ApplicationLauncher launcher;
    @Component
    private P2ApplicationLauncher launcher2;
    private GenerationContext context;
    private ExtensionMojoUtils extensionMojoUtils;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skipStudioPackage) {
            try {
                this.extensionMojoUtils = new ExtensionMojoUtils(this.outputDirectory, this.finalName);
                ExtensionManifest manifest = this.extensionMojoUtils.getExtensionManifest();
                ExtensionModel extensionModel = this.extensionMojoUtils.getExtensionModel();
                this.context = new GenerationContext(this.project, manifest, extensionModel, this.outputDirectory);
                this.generateRequiredArtifacts();
                this.packageArtifacts();
                this.packageUpdateSite();
            }
            catch (Exception e) {
                throw new MojoFailureException("An error occurred creating the Studio UpdateSite", (Throwable)e);
            }
        }
    }

    private void generateRequiredArtifacts() throws MojoFailureException, IOException, ParserConfigurationException, TransformerException {
        File extensionFolder = new File(this.classesDirectory, this.context.getExtensionPluginName());
        ExtensionMojoUtils.createDirectoryIfNotExist(extensionFolder);
        this.copyExtensionModel();
        new StudioIconsGenerator(this.context).generate();
        new StudioEditorsGenerator(this.context).generate();
        new StudioManifestGenerator(this.context).generate();
        new StudioPluginXmlGenerator(this.context).generate();
        new StudioSiteXmlGenerator(this.context).generate();
        new StudioFeatureGenerator(this.context).generate();
    }

    private void packageArtifacts() throws MojoFailureException {
        File featureJar = new FeatureJarGenerator(this.context).generate();
        File pluginJar = new PluginJarGenerator(this.context).generate();
        if (this.signExtension) {
            ComponentSigner componentSigner = new ComponentSigner(this.keystorePath, this.storepass, this.keypass, this.alias, this.tsaUrl);
            componentSigner.sign(featureJar);
            componentSigner.sign(pluginJar);
        }
    }

    private void packageUpdateSite() throws MojoFailureException {
        new FeaturesAndBundlesGenerator(this.context, this.launcher, this.launcher2).generate();
        new StudioPluginZipGenerator(this.context, this.projectHelper).generate();
    }

    private void copyExtensionModel() throws MojoFailureException {
        try (JarFile jar = new JarFile(this.extensionMojoUtils.getExtensionJar());){
            ZipEntry extensionModelEntry = jar.getEntry("META-INF/extension-model.json");
            if (extensionModelEntry == null) {
                throw new MojoFailureException(String.format("The extension does not contain the '%s' file", EXTENSION_MODEL_JSON));
            }
            InputStream inputStream = jar.getInputStream(extensionModelEntry);
            File file = new File(this.context.getPluginOutputDirectory(), EXTENSION_MODEL_JSON);
            Files.copy(inputStream, file.toPath(), new CopyOption[0]);
        }
        catch (Exception e) {
            throw new MojoFailureException("Could not copy extension model file to the Studio Plugin", (Throwable)e);
        }
    }
}

