/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.License;
import org.mule.extension.maven.generator.MavenLicense;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MavenLicenseBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenLicenseBuilder.class);
    private static final List<String> POSSIBLE_LICENSE_FILE_NAMES = Arrays.asList("LICENSE.md", "license.txt", "License.md");
    private final List<File> possibleLicenseFiles = new ArrayList<File>();
    private final List<License> pomFoundLicenses;

    MavenLicenseBuilder(File basedir, List<License> licenses) {
        this.pomFoundLicenses = licenses;
        this.possibleLicenseFiles.addAll(POSSIBLE_LICENSE_FILE_NAMES.stream().map(licenseFileName -> new File(basedir, (String)licenseFileName)).collect(Collectors.toList()));
    }

    MavenLicense build() {
        Optional<String> licenseBody = this.getLicenseFromProject();
        if (!licenseBody.isPresent()) {
            licenseBody = this.getLicenseFromPom();
        }
        return new MavenLicense(licenseBody.orElse(null), this.getLicenseURLFromPom().orElse(null));
    }

    private Optional<String> getLicenseFromProject() {
        Optional<File> optionalLicenseFile = this.possibleLicenseFiles.stream().filter(File::exists).findFirst();
        Optional<String> optionalLicenseBody = Optional.empty();
        if (optionalLicenseFile.isPresent()) {
            File licenseFile = optionalLicenseFile.get();
            try {
                optionalLicenseBody = Optional.of(this.readContentFromFile(licenseFile));
            }
            catch (IOException e) {
                LOGGER.warn(String.format("License could not be read from %s: ", licenseFile) + e.getLocalizedMessage());
            }
        } else {
            LOGGER.warn(String.format("No license could be found in the project with the following names: [%s]", String.join((CharSequence)",", POSSIBLE_LICENSE_FILE_NAMES)));
        }
        return optionalLicenseBody;
    }

    private Optional<String> getLicenseFromPom() {
        Optional<String> licenseBody = Optional.empty();
        if (this.pomFoundLicenses.isEmpty()) {
            LOGGER.warn("No license will be used in the Studio plugin: No license section was found at pom.xml.");
        } else {
            License mavenLicenseObject = this.pomFoundLicenses.get(0);
            Optional<String> optionalUrl = this.getLicenseUrl(mavenLicenseObject);
            if (optionalUrl.isPresent()) {
                licenseBody = this.downloadContentFromUrl(optionalUrl.get());
            } else {
                LOGGER.warn("No license will be used in the Studio plugin: No license URL was specified.");
            }
        }
        return licenseBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> downloadContentFromUrl(String url) {
        Optional<String> optional;
        BufferedReader reader = null;
        try {
            URL licenseURL = new URL(url);
            reader = new BufferedReader(new InputStreamReader(licenseURL.openStream()));
            optional = Optional.of(IOUtils.toString((Reader)reader));
        }
        catch (IOException e) {
            Optional<String> optional2;
            try {
                LOGGER.warn("No license will be used in the Studio plugin: Error reading from the remote URL:  " + e.getMessage());
                optional2 = Optional.empty();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
            return optional2;
        }
        IOUtils.closeQuietly((Reader)reader);
        return optional;
    }

    private Optional<String> getLicenseURLFromPom() {
        if (!this.pomFoundLicenses.isEmpty()) {
            License firstLicense = this.pomFoundLicenses.get(0);
            if (this.pomFoundLicenses.size() > 1) {
                LOGGER.warn(String.format("More than one license has been found for this project, using [%s] license", firstLicense.getName()));
            }
            return this.getLicenseUrl(firstLicense);
        }
        return Optional.empty();
    }

    private Optional<String> getLicenseUrl(License mavenLicenseObject) {
        if (mavenLicenseObject == null || StringUtils.isBlank((String)mavenLicenseObject.getUrl())) {
            return Optional.empty();
        }
        return Optional.of(mavenLicenseObject.getUrl());
    }

    private String readContentFromFile(File filePath) throws IOException {
        try (FileReader licenseReader = new FileReader(filePath);){
            String string = IOUtils.toString((Reader)licenseReader);
            return string;
        }
    }
}

