/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.generator;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Optional;
import org.apache.maven.plugin.MojoFailureException;
import org.mule.extension.maven.generator.GenerationContext;
import org.mule.runtime.extension.api.introspection.property.StudioModelProperty;

public class StudioEditorsGenerator {
    private final GenerationContext context;
    private final File projectBasedir;

    public StudioEditorsGenerator(GenerationContext context) {
        this.context = context;
        this.projectBasedir = context.getMavenProject().getBasedir();
    }

    public void generate() throws MojoFailureException {
        Optional modelProperty = this.context.getExtensionModel().getModelProperty(StudioModelProperty.class);
        if (modelProperty.isPresent() && !((StudioModelProperty)modelProperty.get()).isDerived()) {
            StudioModelProperty studioProperty = (StudioModelProperty)modelProperty.get();
            String editorFileName = studioProperty.getEditorFileName();
            File editorFile = new File(this.projectBasedir, "editor" + File.separator + editorFileName);
            if (!editorFile.exists()) {
                throw new MojoFailureException(String.format("Error generating editors file. The extension is marked to provide ancustom editor file at [%s], but it does not exist.", editorFile));
            }
            File outputFile = new File(this.context.getPluginOutputDirectory(), editorFileName);
            try {
                Files.copy(editorFile.toPath(), outputFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new MojoFailureException(String.format("Error generating editors file. An Error occurred copying the editor file from [%s] to [%s]", editorFile, outputFile), (Throwable)e);
            }
        }
    }
}

