/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.generator;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.mule.extension.maven.generator.GenerationContext;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.introspection.property.StudioModelProperty;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;
import org.mule.runtime.extension.xml.dsl.api.property.XmlModelProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StudioPluginXmlGenerator {
    private static final String CORE_CONTRIBUTION = "org.mule.tooling.core.contribution";
    private static final String MAVEN_POPULATE = "org.mule.tooling.maven.populate";
    private static final String CONTRIBUTION_JAR_TAG = "contribution-jar";
    private static final String EXTERNAL_CONTRIBUTION_TAG = "externalContribution";
    private final MavenProject project;
    private final ExtensionManifest manifest;
    private final ExtensionModel extensionModel;
    private final GenerationContext context;
    private Document pluginDoc;

    public StudioPluginXmlGenerator(GenerationContext context) {
        this.project = context.getMavenProject();
        this.manifest = context.getExtensionManifest();
        this.extensionModel = context.getExtensionModel();
        this.context = context;
    }

    public void generate() throws MojoFailureException {
        try {
            this.pluginDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element pluginElement = this.pluginDoc.createElement("plugin");
            this.pluginDoc.appendChild(pluginElement);
            Element coreContributionExtension = this.createExtensionPoint(CORE_CONTRIBUTION);
            pluginElement.appendChild(coreContributionExtension);
            this.addExternalContribution(coreContributionExtension, this.manifest, this.extensionModel);
            this.addMavenPopulateExtensionPoint(pluginElement);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.pluginDoc);
            StreamResult result = new StreamResult(new File(this.context.getPluginOutputDirectory(), "plugin.xml"));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new MojoFailureException("Error happened generating 'plugin.xml' file", (Throwable)e);
        }
    }

    private void addExternalContribution(Element extensionElement, ExtensionManifest manifest, ExtensionModel extensionModel) throws IOException, MojoFailureException {
        Element externalContributionElement = this.pluginDoc.createElement(EXTERNAL_CONTRIBUTION_TAG);
        externalContributionElement.setAttribute("name", manifest.getName());
        externalContributionElement.setAttribute("version", this.project.getVersion());
        externalContributionElement.setAttribute("minimumVersion", extensionModel.getMinMuleVersion().toCompleteNumericVersion());
        externalContributionElement.setAttribute("contributionVersion", this.project.getVersion());
        externalContributionElement.setAttribute("contributionJar", this.context.getArtifactName() + ".jar");
        externalContributionElement.setAttribute("contributionSources", this.context.getArtifactName() + "-sources.jar");
        externalContributionElement.setAttribute("contributionJavaDocs", this.context.getArtifactName() + "-javadoc.jar");
        externalContributionElement.setAttribute("contributionLibPathInMule", "/plugins");
        externalContributionElement.setAttribute("contributionLibs", "./lib");
        externalContributionElement.setAttribute("contributionType", "mule-extension");
        extensionModel.getModelProperty(XmlModelProperty.class).ifPresent(xmlProperty -> {
            externalContributionElement.setAttribute("contributionNamespace", xmlProperty.getNamespaceUri());
            externalContributionElement.setAttribute("contributionNamespaceFile", xmlProperty.getSchemaLocation());
            externalContributionElement.setAttribute("contributionNamespacePrefix", xmlProperty.getNamespace());
        });
        extensionModel.getModelProperty(StudioModelProperty.class).ifPresent(studioProperty -> {
            if (!studioProperty.isDerived()) {
                externalContributionElement.setAttribute("path", studioProperty.getEditorFileName());
            }
        });
        externalContributionElement.setAttribute("extensionModel", "extension-model.json");
        extensionElement.appendChild(externalContributionElement);
    }

    private void addMavenPopulateExtensionPoint(Element pluginElement) {
        Element mavenPopulateExtension = this.createExtensionPoint(MAVEN_POPULATE);
        pluginElement.appendChild(mavenPopulateExtension);
        this.addJarContribution(mavenPopulateExtension);
    }

    private void addJarContribution(Element extensionElement) {
        Element contributionElement = this.pluginDoc.createElement(CONTRIBUTION_JAR_TAG);
        contributionElement.setAttribute("jar", this.context.getArtifactName() + ".jar");
        extensionElement.appendChild(contributionElement);
    }

    private Element createExtensionPoint(String point) {
        Element extensionElement = this.pluginDoc.createElement("extension");
        extensionElement.setAttribute("point", point);
        return extensionElement;
    }
}

