/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.ArchiverException;
import org.mule.extension.maven.ExtensionDescriptorMojo;
import org.mule.plugin.maven.AbstractPackagePluginMojo;
import org.mule.plugin.maven.ModuleArchiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ExtensionPackageMojo
extends AbstractPackagePluginMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionPackageMojo.class);
    private static final String META_INF = "META-INF";
    public static final String MULE_PLUGIN_JSON = "mule-plugin.json";
    private static final String ICON_SVG = "icon.svg";
    private static final String RESERVED_FOLDER_MULE_ARTIFACT = "META-INF" + File.separator + "mule-artifact" + File.separator;
    private static final String RESERVED_DESTINATION_REPOSITORY = RESERVED_FOLDER_MULE_ARTIFACT + "repository" + File.separator;
    private static final String EXPECTED_ICON_RELATIVE_PATH = File.separator + "icon" + File.separator + "icon.svg";

    protected void addToArchiver(ModuleArchiver archiver) throws MojoFailureException {
        super.addToArchiver(archiver);
        this.addClasses(archiver);
        this.addPluginDescriptor(archiver);
        this.addPOMFile(archiver);
        this.addIcon(archiver);
    }

    private void addPOMFile(ModuleArchiver archiver) {
        archiver.addFile(this.project.getFile(), RESERVED_FOLDER_MULE_ARTIFACT + this.project.getFile().getName());
    }

    private void addIcon(ModuleArchiver archiver) throws MojoFailureException {
        File iconFile = new File(this.project.getBasedir(), EXPECTED_ICON_RELATIVE_PATH);
        if (!iconFile.exists()) {
            LOGGER.warn(String.format("The icon [%s] was not found in the current project, a generic one will be used instead. To replace it with a custom icon put an SVG file under [%s]", iconFile.getAbsolutePath(), EXPECTED_ICON_RELATIVE_PATH));
            String resourceIcon = "generic-connector.svg";
            InputStream resource = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("generic-connector.svg");
            try {
                iconFile = new File(this.outputDirectory, ICON_SVG);
                Files.copy(resource, Paths.get(iconFile.getAbsolutePath(), new String[0]), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new MojoFailureException(String.format("There was an issue while copying the resource [%s]", "generic-connector.svg"), (Throwable)e);
            }
        }
        archiver.addFile(iconFile, RESERVED_FOLDER_MULE_ARTIFACT + ICON_SVG);
    }

    private void addPluginDescriptor(ModuleArchiver archiver) throws MojoFailureException {
        Path path = ExtensionDescriptorMojo.descriptorPathOrFail(this.outputDirectory);
        archiver.addFile(path.toFile(), RESERVED_FOLDER_MULE_ARTIFACT + MULE_PLUGIN_JSON);
    }

    protected void addDependencies(ModuleArchiver archiver) {
        Path startPath = Paths.get(this.outputDirectory.getAbsolutePath(), "repository");
        this.walkWhileCopyingFolder(archiver, RESERVED_DESTINATION_REPOSITORY, startPath);
    }

    protected String getArtifactType() {
        return "jar";
    }

    protected String getArtifactClassifier() {
        return "mule-plugin";
    }

    protected void doAddArtifactProperties(File pluginPropertiesFile) throws MojoFailureException {
    }

    protected void addArtifactProperties(ModuleArchiver archiver) throws ArchiverException {
    }

    protected File getMuleArtifactFile() {
        return new File(this.outputDirectory, this.finalName + "-" + "mule-plugin" + ".jar");
    }
}

