/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extensions.request.builder;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.extensions.request.builder.exception.RequestEntityParsingException;
import com.mulesoft.extensions.request.builder.handler.DefaultResponseHandler;
import com.mulesoft.extensions.request.builder.handler.JacksonResponseHandler;
import com.mulesoft.extensions.request.builder.handler.ResponseHandler;
import com.mulesoft.extensions.request.builder.listener.RequestListener;
import com.mulesoft.extensions.request.builder.parser.ParsingFunction;
import com.mulesoft.extensions.request.builder.request.Method;
import com.mulesoft.extensions.request.builder.request.SimpleRequest;
import com.mulesoft.extensions.request.builder.util.SimpleParameterizedType;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.apache.commons.text.StrSubstitutor;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.message.HttpMessageBuilder;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBuilder<T>
extends HttpMessageBuilder<RequestBuilder<T>, HttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(RequestBuilder.class);
    private final HttpClient client;
    private final Method method;
    private final String path;
    private final Map<String, String> pathParams = new HashMap<String, String>();
    private final MultiMap<String, String> queryParams = new MultiMap();
    private HttpAuthentication authentication;
    private ResponseHandler<T> responseHandler;
    private List<RequestListener> requestListeners = new ArrayList<RequestListener>();
    private boolean followRedirects;
    private int timeout;

    private RequestBuilder(HttpClient client, Method method, String path, ResponseHandler<T> responseHandler) {
        this.client = client;
        this.method = method;
        this.path = path;
        this.responseHandler = responseHandler;
    }

    public RequestBuilder<T> responseType(Class<?> baseType, Type ... parameterTypes) {
        return this.responseType(new SimpleParameterizedType(baseType, parameterTypes));
    }

    public RequestBuilder<T> responseType(ParameterizedType parameterizedType) {
        this.responseHandler = new JacksonResponseHandler(parameterizedType);
        return this;
    }

    public RequestBuilder<T> responseHandler(ResponseHandler<T> responseHandler) {
        this.responseHandler = responseHandler;
        return this;
    }

    public RequestBuilder<T> header(String key, Object value) {
        Optional.ofNullable(value).map(Object::toString).filter(Predicate.isEqual("").negate()).ifPresent(stringValue -> {
            String cfr_ignored_0 = (String)this.headers.put((Object)key, stringValue);
        });
        return this;
    }

    public RequestBuilder<T> authentication(HttpAuthentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public RequestBuilder<T> basicAuthentication(String username, String password) {
        return this.authentication(HttpAuthentication.basic((String)username, (String)password).build());
    }

    public RequestBuilder<T> ntlmAuthentication(String username, String password) {
        return this.authentication((HttpAuthentication)HttpAuthentication.ntlm((String)username, (String)password).build());
    }

    public RequestBuilder<T> ntlmAuthentication(String username, String password, String domain) {
        return this.ntlmAuthentication(String.format("%s/%s", domain, username), password);
    }

    public RequestBuilder<T> queryParam(String key, Object value) {
        Optional.ofNullable(value).map(Object::toString).filter(Predicate.isEqual("").negate()).ifPresent(stringValue -> {
            String cfr_ignored_0 = (String)this.queryParams.put((Object)key, stringValue);
        });
        return this;
    }

    public RequestBuilder<T> queryParams(MultiMap<String, String> queryParams) {
        this.queryParams.putAll(queryParams);
        return this;
    }

    public RequestBuilder<T> pathParam(String key, Object value) {
        Optional.ofNullable(value).map(Object::toString).filter(Predicate.isEqual("").negate()).ifPresent(stringValue -> this.pathParams.put(key, (String)stringValue));
        return this;
    }

    public RequestBuilder<T> pathParams(Map<String, String> pathParams) {
        Optional.ofNullable(pathParams).ifPresent(this.pathParams::putAll);
        return this;
    }

    public RequestBuilder<T> entity(Object entity) {
        return this.entity(entity, arg_0 -> ((ObjectMapper)new ObjectMapper()).writeValueAsString(arg_0));
    }

    public <I> RequestBuilder<T> entity(I entity, ParsingFunction<I, String> converter) {
        try {
            return this.entity(converter.parse(entity));
        }
        catch (Exception e) {
            throw new RequestEntityParsingException(e);
        }
    }

    public RequestBuilder<T> entity(String entity) {
        this.entity = new ByteArrayHttpEntity(entity.getBytes(Charset.forName("UTF-8")));
        return this;
    }

    public RequestBuilder<T> followRedirects() {
        this.followRedirects = true;
        return this;
    }

    public RequestBuilder<T> doNotFollowRedirects() {
        this.followRedirects = false;
        return this;
    }

    public RequestBuilder<T> timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public RequestBuilder<T> accept(MediaType accept) {
        return Optional.ofNullable(accept).map(Object::toString).map(this::accept).orElse(this);
    }

    public RequestBuilder<T> accept(String accept) {
        return this.header("Accept", accept);
    }

    public RequestBuilder<T> contentType(MediaType contentType) {
        return Optional.ofNullable(contentType).map(Object::toString).map(this::contentType).orElse(this);
    }

    public RequestBuilder<T> contentType(String contentType) {
        return this.header("Content-Type", contentType);
    }

    public RequestBuilder<T> onBeforeRequest(RequestListener ... listeners) {
        this.requestListeners.addAll(Arrays.asList(listeners));
        return this;
    }

    public static <T> RequestBuilder<T> get(HttpClient client, String path, ResponseHandler<T> responseHandler) {
        return new RequestBuilder<T>(client, Method.GET, path, responseHandler);
    }

    public static RequestBuilder<String> get(HttpClient client, String path) {
        return RequestBuilder.get(client, path, new DefaultResponseHandler());
    }

    public static <T> RequestBuilder<T> post(HttpClient client, String path, ResponseHandler<T> responseHandler) {
        return new RequestBuilder<T>(client, Method.POST, path, responseHandler);
    }

    public static RequestBuilder<String> post(HttpClient client, String path) {
        return RequestBuilder.post(client, path, new DefaultResponseHandler());
    }

    public static <T> RequestBuilder<T> put(HttpClient client, String path, ResponseHandler<T> responseHandler) {
        return new RequestBuilder<T>(client, Method.PUT, path, responseHandler);
    }

    public static RequestBuilder<String> put(HttpClient client, String path) {
        return RequestBuilder.put(client, path, new DefaultResponseHandler());
    }

    public static <T> RequestBuilder<T> delete(HttpClient client, String path, ResponseHandler<T> responseHandler) {
        return new RequestBuilder<T>(client, Method.DELETE, path, responseHandler);
    }

    public static RequestBuilder<String> delete(HttpClient client, String path) {
        return RequestBuilder.delete(client, path, new DefaultResponseHandler());
    }

    public static <T> RequestBuilder<T> patch(HttpClient client, String path, ResponseHandler<T> responseHandler) {
        return new RequestBuilder<T>(client, Method.PATCH, path, responseHandler);
    }

    public static RequestBuilder<String> patch(HttpClient client, String path) {
        return RequestBuilder.patch(client, path, new DefaultResponseHandler());
    }

    public static <T> RequestBuilder<T> head(HttpClient client, String path, ResponseHandler<T> responseHandler) {
        return new RequestBuilder<T>(client, Method.HEAD, path, responseHandler);
    }

    public static RequestBuilder<String> head(HttpClient client, String path) {
        return new RequestBuilder<String>(client, Method.HEAD, path, new DefaultResponseHandler());
    }

    public static <T> RequestBuilder<T> options(HttpClient client, String path, ResponseHandler<T> responseHandler) {
        return new RequestBuilder<T>(client, Method.OPTIONS, path, responseHandler);
    }

    public static RequestBuilder<String> options(HttpClient client, String path) {
        return new RequestBuilder<String>(client, Method.OPTIONS, path, new DefaultResponseHandler());
    }

    public SimpleRequest build() {
        Preconditions.checkNotNull((Object)this.path, (String)"URI must be specified to create an HTTP request");
        return new SimpleRequest(new StrSubstitutor(this.pathParams).replace(this.path), this.method, (MultiMap<String, String>)this.headers, this.queryParams, this.entity);
    }

    public T execute() throws IOException, TimeoutException {
        SimpleRequest request = this.build();
        for (RequestListener listener : this.requestListeners) {
            logger.debug("Request Listener {} found. Providing request.", listener.getClass());
            listener.handle(request);
        }
        HttpResponse response = this.client.send((HttpRequest)this.build(), this.timeout, this.followRedirects, this.authentication);
        logger.debug("Parsing response.");
        return this.responseHandler.handleResponse(response);
    }
}

