/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.connectionpool;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectorHandler;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.connectionpool.SingleEndpointPool;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.utils.DataStructures;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SingleEndPointPoolTest {
    private static final int PORT = 18333;
    private final Set<Connection> serverSideConnections = Collections.newSetFromMap(DataStructures.getConcurrentMap());
    private TCPNIOTransport transport;

    @Before
    public void init() throws IOException {
        FilterChain filterChain = FilterChainBuilder.stateless().add((Filter)new TransportFilter()).add((Filter)new BaseFilter(){

            public NextAction handleAccept(FilterChainContext ctx) throws IOException {
                SingleEndPointPoolTest.this.serverSideConnections.add(ctx.getConnection());
                return ctx.getStopAction();
            }

            public NextAction handleClose(FilterChainContext ctx) throws IOException {
                SingleEndPointPoolTest.this.serverSideConnections.remove(ctx.getConnection());
                return ctx.getStopAction();
            }
        }).build();
        this.transport = TCPNIOTransportBuilder.newInstance().build();
        this.transport.setProcessor((Processor)filterChain);
        this.transport.bind(18333);
        this.transport.start();
    }

    @After
    public void tearDown() throws IOException {
        this.serverSideConnections.clear();
        if (this.transport != null) {
            this.transport.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalAddress() throws Exception {
        InetSocketAddress localAddress = new InetSocketAddress("localhost", 60000);
        try (SingleEndpointPool pool = SingleEndpointPool.builder(SocketAddress.class).connectorHandler((ConnectorHandler)this.transport).endpointAddress((Object)new InetSocketAddress("localhost", 18333)).localEndpointAddress((Object)localAddress).build();){
            Connection c1 = (Connection)pool.take().get();
            Assert.assertEquals((Object)localAddress, (Object)c1.getLocalAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicPollRelease() throws Exception {
        try (SingleEndpointPool pool = SingleEndpointPool.builder(SocketAddress.class).connectorHandler((ConnectorHandler)this.transport).endpointAddress((Object)new InetSocketAddress("localhost", 18333)).build();){
            Connection c1 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c1);
            Assert.assertEquals((long)1L, (long)pool.size());
            Connection c2 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c2);
            Assert.assertEquals((long)2L, (long)pool.size());
            Assert.assertTrue((boolean)pool.release(c1));
            Assert.assertEquals((long)2L, (long)pool.size());
            Assert.assertTrue((boolean)pool.release(c2));
            Assert.assertEquals((long)2L, (long)pool.size());
            c1 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c1);
            Assert.assertEquals((long)2L, (long)pool.size());
            Assert.assertTrue((boolean)pool.detach(c1));
            Assert.assertEquals((long)1L, (long)pool.size());
            Assert.assertTrue((boolean)pool.attach(c1));
            Assert.assertEquals((long)2L, (long)pool.size());
            Assert.assertEquals((long)1L, (long)pool.getReadyConnectionsCount());
            Assert.assertTrue((boolean)pool.release(c1));
            Assert.assertEquals((long)2L, (long)pool.size());
            Assert.assertEquals((long)2L, (long)pool.getReadyConnectionsCount());
            c1 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c1);
            Assert.assertEquals((long)1L, (long)pool.getReadyConnectionsCount());
            c2 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c2);
            Assert.assertEquals((long)0L, (long)pool.getReadyConnectionsCount());
            c1.close().get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)pool.size());
            c2.close().get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)pool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPollWaitForRelease() throws Exception {
        try (final SingleEndpointPool pool = SingleEndpointPool.builder(SocketAddress.class).connectorHandler((ConnectorHandler)this.transport).endpointAddress((Object)new InetSocketAddress("localhost", 18333)).maxPoolSize(2).build();){
            Connection c1 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c1);
            Assert.assertEquals((long)1L, (long)pool.size());
            final Connection c2 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c2);
            Assert.assertEquals((long)2L, (long)pool.size());
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    pool.release(c2);
                }
            };
            t.start();
            Connection c3 = (Connection)pool.take().get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)c3);
            Assert.assertEquals((long)2L, (long)pool.size());
            pool.release(c1);
            Assert.assertEquals((long)2L, (long)pool.size());
            pool.release(c3);
            Assert.assertEquals((long)2L, (long)pool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPollTimeout() throws Exception {
        try (SingleEndpointPool pool = SingleEndpointPool.builder(SocketAddress.class).connectorHandler((ConnectorHandler)this.transport).endpointAddress((Object)new InetSocketAddress("localhost", 18333)).corePoolSize(2).maxPoolSize(2).build();){
            Connection c1 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c1);
            Assert.assertEquals((long)1L, (long)pool.size());
            Connection c2 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c2);
            Assert.assertEquals((long)2L, (long)pool.size());
            GrizzlyFuture c3Future = pool.take();
            try {
                c3Future.get(2L, TimeUnit.SECONDS);
                Assert.fail((String)"TimeoutException had to be thrown");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)c3Future.cancel(false));
            Assert.assertEquals((long)2L, (long)pool.size());
            pool.release(c2);
            Connection c3 = (Connection)pool.take().get(2L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)c3);
            Assert.assertEquals((long)2L, (long)pool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmbeddedPollTimeout() throws Exception {
        try (SingleEndpointPool pool = SingleEndpointPool.builder(SocketAddress.class).connectorHandler((ConnectorHandler)this.transport).endpointAddress((Object)new InetSocketAddress("localhost", 18333)).corePoolSize(2).maxPoolSize(2).asyncPollTimeout(2L, TimeUnit.SECONDS).build();){
            Connection c1 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c1);
            Assert.assertEquals((long)1L, (long)pool.size());
            Connection c2 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c2);
            Assert.assertEquals((long)2L, (long)pool.size());
            GrizzlyFuture c3Future = pool.take();
            try {
                c3Future.get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                Assert.assertTrue((String)("Unexpected exception " + cause), (boolean)(cause instanceof TimeoutException));
            }
            catch (Throwable e) {
                Assert.fail((String)("Unexpected exception " + e));
            }
            Assert.assertFalse((boolean)c3Future.cancel(false));
            Assert.assertEquals((long)2L, (long)pool.size());
            pool.release(c2);
            Connection c3 = (Connection)pool.take().get(2L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)c3);
            Assert.assertEquals((long)2L, (long)pool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeepAliveTimeout() throws Exception {
        long keepAliveTimeoutMillis = 5000L;
        long keepAliveCheckIntervalMillis = 1000L;
        int corePoolSize = 2;
        int maxPoolSize = 5;
        try (SingleEndpointPool pool = SingleEndpointPool.builder(SocketAddress.class).connectorHandler((ConnectorHandler)this.transport).endpointAddress((Object)new InetSocketAddress("localhost", 18333)).corePoolSize(2).maxPoolSize(5).keepAliveTimeout(5000L, TimeUnit.MILLISECONDS).keepAliveCheckInterval(1000L, TimeUnit.MILLISECONDS).build();){
            int i;
            Connection[] connections = new Connection[5];
            for (i = 0; i < 5; ++i) {
                connections[i] = (Connection)pool.take().get();
                Assert.assertNotNull((Object)connections[i]);
                Assert.assertEquals((long)(i + 1), (long)pool.size());
            }
            for (i = 0; i < 5; ++i) {
                pool.release(connections[i]);
                Assert.assertEquals((long)(i + 1), (long)pool.getReadyConnectionsCount());
            }
            Thread.sleep(7000L);
            Assert.assertEquals((long)2L, (long)pool.size());
            Assert.assertEquals((long)2L, (long)this.serverSideConnections.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReconnect() throws Exception {
        long reconnectDelayMillis = 1000L;
        FilterChain filterChain = FilterChainBuilder.stateless().add((Filter)new TransportFilter()).build();
        TCPNIOTransport clientTransport = ((TCPNIOTransportBuilder)TCPNIOTransportBuilder.newInstance().setProcessor((Processor)filterChain)).build();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    SingleEndPointPoolTest.this.init();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        SingleEndpointPool pool = SingleEndpointPool.builder(SocketAddress.class).connectorHandler((ConnectorHandler)clientTransport).endpointAddress((Object)new InetSocketAddress("localhost", 18333)).corePoolSize(4).maxPoolSize(5).keepAliveTimeout(-1L, TimeUnit.SECONDS).reconnectDelay(1000L, TimeUnit.MILLISECONDS).build();
        try {
            clientTransport.start();
            this.transport.shutdownNow();
            t.start();
            Connection c1 = (Connection)pool.take().get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)c1);
            Assert.assertEquals((long)1L, (long)pool.size());
        }
        finally {
            t.join();
            pool.close();
            clientTransport.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReconnectFailureNotification() throws Exception {
        long reconnectDelayMillis = 1000L;
        FilterChain filterChain = FilterChainBuilder.stateless().add((Filter)new TransportFilter()).build();
        TCPNIOTransport clientTransport = ((TCPNIOTransportBuilder)TCPNIOTransportBuilder.newInstance().setProcessor((Processor)filterChain)).build();
        SingleEndpointPool pool = SingleEndpointPool.builder(SocketAddress.class).connectorHandler((ConnectorHandler)clientTransport).endpointAddress((Object)new InetSocketAddress("localhost", 18333)).corePoolSize(4).maxPoolSize(5).keepAliveTimeout(-1L, TimeUnit.SECONDS).reconnectDelay(1000L, TimeUnit.MILLISECONDS).build();
        try {
            clientTransport.start();
            this.transport.shutdownNow();
            final AtomicBoolean notified = new AtomicBoolean();
            final AtomicReference connection = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            pool.take((CompletionHandler)new EmptyCompletionHandler<Connection>(){

                public void failed(Throwable throwable) {
                    notified.set(true);
                    latch.countDown();
                }

                public void completed(Connection result) {
                    connection.set(result);
                    latch.countDown();
                }
            });
            latch.await(15L, TimeUnit.SECONDS);
            Assert.assertNull(connection.get());
            Assert.assertTrue((boolean)notified.get());
            Assert.assertEquals((long)0L, (long)pool.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            pool.close();
            clientTransport.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionTTL() throws Exception {
        SingleEndpointPool pool = SingleEndpointPool.builder(SocketAddress.class).connectorHandler((ConnectorHandler)this.transport).endpointAddress((Object)new InetSocketAddress("localhost", 18333)).connectionTTL(2L, TimeUnit.SECONDS).build();
        try {
            Connection c1 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c1);
            Assert.assertEquals((long)1L, (long)pool.size());
            Connection c2 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c2);
            Assert.assertEquals((long)2L, (long)pool.size());
            pool.release(c1);
            long t1 = System.currentTimeMillis();
            while (pool.size() > 0) {
                Assert.assertTrue((String)("Timeout. pool size is still: " + pool.size()), (System.currentTimeMillis() - t1 <= 5000L ? 1 : 0) != 0);
                Thread.sleep(1000L);
            }
            Assert.assertEquals((long)0L, (long)pool.size());
            Assert.assertTrue((!c1.isOpen() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)c2.isOpen());
            pool.release(c2);
            Assert.assertTrue((!c2.isOpen() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            pool.close();
            this.transport.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeepAliveZero() throws Exception {
        SingleEndpointPool pool = SingleEndpointPool.builder(SocketAddress.class).corePoolSize(2).maxPoolSize(4).failFastWhenMaxSizeReached(true).connectorHandler((ConnectorHandler)this.transport).endpointAddress((Object)new InetSocketAddress("localhost", 18333)).keepAliveTimeout(0L, TimeUnit.MILLISECONDS).build();
        try {
            Connection c1 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c1);
            Assert.assertEquals((long)1L, (long)pool.size());
            Connection c2 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c2);
            Assert.assertEquals((long)2L, (long)pool.size());
            Connection c3 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c3);
            Assert.assertEquals((long)3L, (long)pool.size());
            Connection c4 = (Connection)pool.take().get();
            Assert.assertNotNull((Object)c4);
            Assert.assertEquals((long)4L, (long)pool.size());
            pool.release(c1);
            Assert.assertEquals((long)3L, (long)pool.size());
            pool.release(c2);
            Assert.assertEquals((long)2L, (long)pool.size());
            pool.release(c3);
            Assert.assertEquals((long)2L, (long)pool.size());
            pool.release(c4);
            Assert.assertEquals((long)2L, (long)pool.size());
            Assert.assertTrue((!c1.isOpen() ? 1 : 0) != 0);
            Assert.assertTrue((!c2.isOpen() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)c3.isOpen());
            Assert.assertTrue((boolean)c4.isOpen());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            pool.close();
            this.transport.shutdownNow();
        }
    }
}

