/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.connectionpool;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectorHandler;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.connectionpool.Endpoint;
import org.glassfish.grizzly.connectionpool.MultiEndpointPool;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.utils.DataStructures;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiEndPointPoolTest {
    private static final int PORT = 18334;
    private static final int NUMBER_OF_PORTS_TO_BIND = 3;
    private final Set<Connection> serverSideConnections = Collections.newSetFromMap(DataStructures.getConcurrentMap());
    private TCPNIOTransport transport;

    @Before
    public void init() throws IOException {
        FilterChain filterChain = FilterChainBuilder.stateless().add((Filter)new TransportFilter()).add((Filter)new BaseFilter(){

            public NextAction handleAccept(FilterChainContext ctx) throws IOException {
                MultiEndPointPoolTest.this.serverSideConnections.add(ctx.getConnection());
                return ctx.getStopAction();
            }

            public NextAction handleClose(FilterChainContext ctx) throws IOException {
                MultiEndPointPoolTest.this.serverSideConnections.remove(ctx.getConnection());
                return ctx.getStopAction();
            }
        }).build();
        this.transport = TCPNIOTransportBuilder.newInstance().build();
        this.transport.setProcessor((Processor)filterChain);
        for (int i = 0; i < 3; ++i) {
            this.transport.bind(18334 + i);
        }
        this.transport.start();
    }

    @After
    public void tearDown() throws IOException {
        this.serverSideConnections.clear();
        if (this.transport != null) {
            this.transport.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalAddress() throws Exception {
        InetSocketAddress localAddress = new InetSocketAddress("localhost", 60000);
        Endpoint key1 = Endpoint.Factory.create((Object)new InetSocketAddress("localhost", 18334), (Object)localAddress, (ConnectorHandler)this.transport);
        try (MultiEndpointPool pool = MultiEndpointPool.builder(SocketAddress.class).maxConnectionsPerEndpoint(3).maxConnectionsTotal(15).keepAliveTimeout(-1L, TimeUnit.SECONDS).build();){
            Connection c1 = (Connection)pool.take(key1).get();
            Assert.assertEquals((Object)localAddress, (Object)c1.getLocalAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicPollRelease() throws Exception {
        try (MultiEndpointPool pool = MultiEndpointPool.builder(SocketAddress.class).maxConnectionsPerEndpoint(3).maxConnectionsTotal(15).keepAliveTimeout(-1L, TimeUnit.SECONDS).build();){
            Endpoint key1 = Endpoint.Factory.create((Object)new InetSocketAddress("localhost", 18334), (ConnectorHandler)this.transport);
            Endpoint key2 = Endpoint.Factory.create((Object)new InetSocketAddress("localhost", 18335), (ConnectorHandler)this.transport);
            Connection c11 = (Connection)pool.take(key1).get();
            Assert.assertNotNull((Object)c11);
            Assert.assertEquals((long)1L, (long)pool.size());
            Connection c12 = (Connection)pool.take(key1).get();
            Assert.assertNotNull((Object)c12);
            Assert.assertEquals((long)2L, (long)pool.size());
            Connection c21 = (Connection)pool.take(key2).get();
            Assert.assertNotNull((Object)c21);
            Assert.assertEquals((long)3L, (long)pool.size());
            Connection c22 = (Connection)pool.take(key2).get();
            Assert.assertNotNull((Object)c22);
            Assert.assertEquals((long)4L, (long)pool.size());
            Assert.assertTrue((boolean)pool.release(c11));
            Assert.assertEquals((long)4L, (long)pool.size());
            Assert.assertTrue((boolean)pool.release(c21));
            Assert.assertEquals((long)4L, (long)pool.size());
            c11 = (Connection)pool.take(key1).get();
            Assert.assertNotNull((Object)c11);
            Assert.assertEquals((long)4L, (long)pool.size());
            Assert.assertTrue((boolean)pool.detach(c11));
            Assert.assertEquals((long)3L, (long)pool.size());
            Assert.assertTrue((boolean)pool.attach(key1, c11));
            Assert.assertEquals((long)4L, (long)pool.size());
            Assert.assertTrue((boolean)pool.release(c11));
            Assert.assertEquals((long)4L, (long)pool.size());
            c11 = (Connection)pool.take(key1).get();
            Assert.assertNotNull((Object)c11);
            c21 = (Connection)pool.take(key2).get();
            Assert.assertNotNull((Object)c21);
            c11.close().get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)3L, (long)pool.size());
            c12.close().get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)2L, (long)pool.size());
            c21.close().get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)pool.size());
            c22.close().get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)pool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTotalPoolSizeLimit() throws Exception {
        try (MultiEndpointPool pool = MultiEndpointPool.builder(SocketAddress.class).maxConnectionsPerEndpoint(2).maxConnectionsTotal(2).keepAliveTimeout(-1L, TimeUnit.SECONDS).build();){
            Endpoint key1 = Endpoint.Factory.create((Object)new InetSocketAddress("localhost", 18334), (ConnectorHandler)this.transport);
            Endpoint key2 = Endpoint.Factory.create((Object)new InetSocketAddress("localhost", 18335), (ConnectorHandler)this.transport);
            Connection c11 = (Connection)pool.take(key1).get();
            Assert.assertNotNull((Object)c11);
            Assert.assertEquals((long)1L, (long)pool.size());
            final Connection c12 = (Connection)pool.take(key1).get();
            Assert.assertNotNull((Object)c12);
            Assert.assertEquals((long)2L, (long)pool.size());
            GrizzlyFuture c21Future = pool.take(key2);
            try {
                c21Future.get(2L, TimeUnit.SECONDS);
                Assert.fail((String)"TimeoutException had to be thrown");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)c21Future.cancel(false));
            Assert.assertEquals((long)2L, (long)pool.size());
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    c12.closeSilently();
                }
            };
            t.start();
            Connection c21 = (Connection)pool.take(key2).get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)c12);
            Assert.assertEquals((long)2L, (long)pool.size());
            c11.close().get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)pool.size());
            c21.close().get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)pool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleEndpointClose() throws Exception {
        int maxConnectionsPerEndpoint = 4;
        try (MultiEndpointPool pool = MultiEndpointPool.builder(SocketAddress.class).maxConnectionsPerEndpoint(4).maxConnectionsTotal(8).keepAliveTimeout(-1L, TimeUnit.SECONDS).build();){
            int i;
            Endpoint key1 = Endpoint.Factory.create((Object)new InetSocketAddress("localhost", 18334), (ConnectorHandler)this.transport);
            Endpoint key2 = Endpoint.Factory.create((Object)new InetSocketAddress("localhost", 18335), (ConnectorHandler)this.transport);
            Connection[] e1Connections = new Connection[4];
            Connection[] e2Connections = new Connection[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                e1Connections[i2] = (Connection)pool.take(key1).get();
                Assert.assertNotNull((Object)e1Connections[i2]);
                Assert.assertEquals((long)(i2 * 2 + 1), (long)pool.size());
                e2Connections[i2] = (Connection)pool.take(key2).get();
                Assert.assertNotNull((Object)e2Connections[i2]);
                Assert.assertEquals((long)(i2 * 2 + 2), (long)pool.size());
            }
            int numberOfReleasedConnections = 2;
            for (i = 0; i < 2; ++i) {
                pool.release(e1Connections[i]);
                Assert.assertNotNull((Object)e1Connections[i]);
            }
            pool.close(key1);
            Assert.assertEquals((long)4L, (long)pool.size());
            for (i = 0; i < 2; ++i) {
                Assert.assertFalse((boolean)e1Connections[i].isOpen());
            }
            for (i = 2; i < 4; ++i) {
                Assert.assertTrue((boolean)e1Connections[i].isOpen());
            }
            for (i = 2; i < 4; ++i) {
                pool.release(e1Connections[i]);
            }
            for (i = 2; i < 4; ++i) {
                Assert.assertFalse((boolean)e1Connections[i].isOpen());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmbeddedPollTimeout() throws Exception {
        int maxConnectionsPerEndpoint = 2;
        try (MultiEndpointPool pool = MultiEndpointPool.builder(SocketAddress.class).maxConnectionsPerEndpoint(2).maxConnectionsTotal(4).keepAliveTimeout(-1L, TimeUnit.SECONDS).asyncPollTimeout(2L, TimeUnit.SECONDS).build();){
            Endpoint key = Endpoint.Factory.create((Object)new InetSocketAddress("localhost", 18334), (ConnectorHandler)this.transport);
            Connection c1 = (Connection)pool.take(key).get();
            Assert.assertNotNull((Object)c1);
            Assert.assertEquals((long)1L, (long)pool.size());
            Connection c2 = (Connection)pool.take(key).get();
            Assert.assertNotNull((Object)c2);
            Assert.assertEquals((long)2L, (long)pool.size());
            GrizzlyFuture c3Future = pool.take(key);
            try {
                c3Future.get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                Assert.assertTrue((String)("Unexpected exception " + cause), (boolean)(cause instanceof TimeoutException));
            }
            catch (Throwable e) {
                Assert.fail((String)("Unexpected exception " + e));
            }
            Assert.assertFalse((boolean)c3Future.cancel(false));
            Assert.assertEquals((long)2L, (long)pool.size());
            pool.release(c2);
            Connection c3 = (Connection)pool.take(key).get(2L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)c3);
            Assert.assertEquals((long)2L, (long)pool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEndpointPoolCustomizer() throws Exception {
        final Endpoint key1 = Endpoint.Factory.create((Object)new InetSocketAddress("localhost", 18334), (ConnectorHandler)this.transport);
        Endpoint key2 = Endpoint.Factory.create((Object)new InetSocketAddress("localhost", 18335), (ConnectorHandler)this.transport);
        int maxConnectionsPerEndpoint = 2;
        try (MultiEndpointPool pool = MultiEndpointPool.builder(SocketAddress.class).maxConnectionsPerEndpoint(2).maxConnectionsTotal(4).keepAliveTimeout(-1L, TimeUnit.SECONDS).endpointPoolCustomizer((MultiEndpointPool.EndpointPoolCustomizer)new MultiEndpointPool.EndpointPoolCustomizer<SocketAddress>(){

            public void customize(Endpoint<SocketAddress> endpoint, MultiEndpointPool.EndpointPoolBuilder<SocketAddress> builder) {
                if (endpoint.equals((Object)key1)) {
                    builder.keepAliveTimeout(0L, TimeUnit.SECONDS);
                }
            }
        }).build();){
            Connection c1 = (Connection)pool.take(key1).get();
            Assert.assertNotNull((Object)c1);
            Assert.assertEquals((long)1L, (long)pool.size());
            Connection c2 = (Connection)pool.take(key2).get();
            Assert.assertNotNull((Object)c2);
            Assert.assertEquals((long)2L, (long)pool.size());
            pool.release(c2);
            Assert.assertEquals((long)2L, (long)pool.size());
            Assert.assertEquals((long)2L, (long)pool.getOpenConnectionsCount());
            pool.release(c1);
            Assert.assertEquals((long)1L, (long)pool.size());
            Assert.assertEquals((long)1L, (long)pool.getOpenConnectionsCount());
        }
    }
}

