/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy.v31;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueRecord;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.spdy.SessionOutputSink;
import org.glassfish.grizzly.spdy.SpdySession;
import org.glassfish.grizzly.spdy.SpdyStream;
import org.glassfish.grizzly.spdy.frames.DataFrame;
import org.glassfish.grizzly.spdy.frames.SpdyFrame;
import org.glassfish.grizzly.spdy.frames.WindowUpdateFrame;
import org.glassfish.grizzly.spdy.utils.ChunkedCompletionHandler;
import org.glassfish.grizzly.spdy.v31.AggrCompletionHandler;
import org.slf4j.Logger;

final class SessionOutputSink31
extends SessionOutputSink {
    private static final Logger LOGGER = Grizzly.logger(SessionOutputSink31.class);
    private static final int MAX_OUTPUT_QUEUE_SIZE = 65536;
    final TaskQueue<OutputQueueRecord> outputQueue = TaskQueue.createTaskQueue(new TaskQueue.MutableMaxQueueSize(){

        @Override
        public int getMaxQueueSize() {
            return 65536;
        }
    });
    private final AtomicInteger availConnectionWindowSize = new AtomicInteger(65536);
    private final List<SpdyFrame> tmpFramesList = new LinkedList<SpdyFrame>();
    private final AtomicBoolean writerLock = new AtomicBoolean();
    private final AtomicInteger unackedReadBytes = new AtomicInteger();

    public SessionOutputSink31(SpdySession session) {
        super(session);
    }

    @Override
    protected int getAvailablePeerConnectionWindowSize() {
        return this.availConnectionWindowSize.get();
    }

    @Override
    protected boolean canWrite() {
        return this.outputQueue.size() < 65536;
    }

    @Override
    protected void notifyCanWrite(WriteHandler writeHandler) {
        this.outputQueue.notifyWritePossible(writeHandler, 65536);
    }

    @Override
    protected void onPeerWindowUpdate(int delta) {
        int newWindowSize = this.availConnectionWindowSize.addAndGet(delta);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SpdySession. Expand connection window size by {} bytes. Current connection window size is: {}", (Object)delta, (Object)newWindowSize);
        }
        this.flushOutputQueue();
    }

    void sendWindowUpdate(int delta) {
        int windowSize;
        int currentUnackedBytes = this.unackedReadBytes.addAndGet(delta);
        if (currentUnackedBytes > (windowSize = this.session.getLocalConnectionWindowSize()) / 3 && this.unackedReadBytes.compareAndSet(currentUnackedBytes, 0)) {
            this.writeDownStream(WindowUpdateFrame.builder().streamId(0).delta(currentUnackedBytes).build(), null);
        }
    }

    @Override
    protected void writeDataDownStream(SpdyStream spdyStream, SpdyFrame headerFrame, Buffer data, CompletionHandler<WriteResult> completionHandler, MessageCloner<Buffer> messageCloner, boolean isLast) {
        if (data == null || !data.hasRemaining() && spdyStream.getUnflushedWritesCount() == 1) {
            super.writeDataDownStream(spdyStream, headerFrame, data, completionHandler, messageCloner, isLast);
            return;
        }
        if (headerFrame != null) {
            this.writeDownStream(headerFrame);
        }
        int dataSize = data.remaining();
        if (messageCloner != null) {
            data = messageCloner.clone(this.session.getConnection(), data);
        }
        OutputQueueRecord record = new OutputQueueRecord(spdyStream.getStreamId(), data, completionHandler, isLast);
        this.outputQueue.offer(record);
        this.outputQueue.reserveSpace(record.isZeroSizeData() ? 1 : dataSize);
        this.flushOutputQueue();
    }

    private void flushOutputQueue() {
        int backoffDelay = 0;
        boolean needToNotify = false;
        int tmpcnt = 0;
        while (this.availConnectionWindowSize.get() > 0 && !this.outputQueue.isEmpty() && this.writerLock.compareAndSet(false, true)) {
            int availWindowSize = this.availConnectionWindowSize.get();
            int queueSize = this.outputQueue.size();
            AggrCompletionHandler writeCompletionHandler = null;
            int writeCompletionHandlerBytes = 0;
            int bytesToTransfer = 0;
            int queueSizeToFree = 0;
            AggrCompletionHandler completionHandlers = null;
            while (availWindowSize > bytesToTransfer && queueSize > queueSizeToFree) {
                AggrCompletionHandler recordCompletionHandler;
                OutputQueueRecord record = this.outputQueue.poll();
                if (record == null) {
                    LOGGER.warn("UNEXPECTED NULL RECORD. Queue-size: {} tmpcnt={} byteToTransfer={} queueSizeToFree={} queueSize={}", new Object[]{this.outputQueue.size(), tmpcnt, bytesToTransfer, queueSizeToFree, queueSize});
                }
                assert (record != null);
                int serializedBytes = record.serializeTo(this.tmpFramesList, availWindowSize - bytesToTransfer);
                bytesToTransfer += serializedBytes;
                queueSizeToFree += serializedBytes;
                if (record.isFinished()) {
                    if (record.isZeroSizeData()) {
                        ++queueSizeToFree;
                    }
                } else {
                    this.outputQueue.setCurrentElement(record);
                }
                if ((recordCompletionHandler = record.getCompletionHandler()) == null) continue;
                if (completionHandlers != null) {
                    completionHandlers.register(recordCompletionHandler, serializedBytes);
                    continue;
                }
                if (writeCompletionHandler == null) {
                    writeCompletionHandler = recordCompletionHandler;
                    writeCompletionHandlerBytes = serializedBytes;
                    continue;
                }
                completionHandlers = new AggrCompletionHandler();
                completionHandlers.register(writeCompletionHandler, writeCompletionHandlerBytes);
                completionHandlers.register(recordCompletionHandler, serializedBytes);
                writeCompletionHandler = completionHandlers;
            }
            if (queueSizeToFree > 0) {
                assert (!this.tmpFramesList.isEmpty());
                this.writeDownStream(this.tmpFramesList, writeCompletionHandler, null);
                int newWindowSize = this.availConnectionWindowSize.addAndGet(-bytesToTransfer);
                this.outputQueue.releaseSpace(queueSizeToFree);
                needToNotify = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("SpdySession. Shrink connection window size by {} bytes. Current connection window size is: {}", (Object)bytesToTransfer, (Object)newWindowSize);
                }
            }
            this.writerLock.set(false);
            LockSupport.parkNanos(backoffDelay++);
            ++tmpcnt;
        }
        if (needToNotify) {
            this.outputQueue.doNotify();
        }
    }

    @Override
    public void close() {
        this.outputQueue.onClose();
    }

    private static class OutputQueueRecord
    extends AsyncQueueRecord<WriteResult> {
        private final int streamId;
        private ChunkedCompletionHandler chunkedCompletionHandler;
        private final CompletionHandler<WriteResult> originalCompletionHandler;
        private Buffer buffer;
        private final boolean isLast;
        private final boolean isZeroSizeData;

        public OutputQueueRecord(int streamId, Buffer buffer, CompletionHandler<WriteResult> completionHandler, boolean isLast) {
            super(null, null, null);
            this.streamId = streamId;
            this.buffer = buffer;
            this.isZeroSizeData = !buffer.hasRemaining();
            this.originalCompletionHandler = completionHandler;
            this.isLast = isLast;
        }

        public CompletionHandler<WriteResult> getCompletionHandler() {
            return this.chunkedCompletionHandler != null ? this.chunkedCompletionHandler : this.originalCompletionHandler;
        }

        @Override
        public void notifyFailure(Throwable e) {
            CompletionHandler<WriteResult> chLocal = this.getCompletionHandler();
            if (chLocal != null) {
                chLocal.failed(e);
            }
        }

        @Override
        public void recycle() {
        }

        @Override
        public WriteResult getCurrentResult() {
            return null;
        }

        private boolean isZeroSizeData() {
            return this.isZeroSizeData;
        }

        private boolean isFinished() {
            return this.buffer == null;
        }

        private int serializeTo(List<SpdyFrame> frames, int maxDataSize) {
            int recordSize = this.buffer.remaining();
            if (recordSize <= maxDataSize) {
                DataFrame dataFrame = DataFrame.builder().streamId(this.streamId).data(this.buffer).last(this.isLast).build();
                frames.add(dataFrame);
                this.buffer = null;
                return recordSize;
            }
            if (this.originalCompletionHandler != null && this.chunkedCompletionHandler == null) {
                this.chunkedCompletionHandler = new ChunkedCompletionHandler(this.originalCompletionHandler);
            }
            if (this.chunkedCompletionHandler != null) {
                this.chunkedCompletionHandler.incChunks();
            }
            Buffer remainder = this.buffer.split(this.buffer.position() + maxDataSize);
            DataFrame dataFrame = DataFrame.builder().streamId(this.streamId).data(this.buffer).last(false).build();
            frames.add(dataFrame);
            this.buffer = remainder;
            return maxDataSize;
        }
    }
}

