/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.glassfish.grizzly.AbstractSocketConnectorHandler;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventLifeCycleListener;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.nio.NIOChannelDistributor;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.transport.UDPNIOConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.utils.Futures;

public class UDPNIOConnectorHandler
extends AbstractSocketConnectorHandler {
    private static final Logger LOGGER = Grizzly.logger(UDPNIOConnectorHandler.class);
    protected boolean isReuseAddress;
    protected volatile long connectionTimeoutMillis = 30000L;

    protected UDPNIOConnectorHandler(UDPNIOTransport transport) {
        super(transport);
        this.connectionTimeoutMillis = transport.getConnectionTimeout();
        this.isReuseAddress = transport.isReuseAddress();
    }

    public GrizzlyFuture<Connection> connect() {
        return this.connectAsync(null, null, null, true);
    }

    @Override
    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) {
        if (!this.transport.isBlocking()) {
            return this.connectAsync(remoteAddress, localAddress, completionHandler, false);
        }
        return this.connectSync(remoteAddress, localAddress, completionHandler);
    }

    protected GrizzlyFuture<Connection> connectSync(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) {
        FutureImpl<Connection> future = this.connectAsync(remoteAddress, localAddress, completionHandler, true);
        this.waitNIOFuture(future, completionHandler);
        return future;
    }

    @Override
    protected FutureImpl<Connection> connectAsync(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler, boolean needFuture) {
        UDPNIOTransport nioTransport = (UDPNIOTransport)this.transport;
        NIOConnection newConnection = null;
        try {
            CompletionHandler<Connection> completionHandlerToPass;
            FutureImpl<Connection> futureToReturn;
            DatagramChannel datagramChannel = nioTransport.getSelectorProvider().openDatagramChannel();
            nioTransport.getChannelConfigurator().preConfigure(nioTransport, datagramChannel);
            DatagramSocket socket = datagramChannel.socket();
            newConnection = nioTransport.obtainNIOConnection(datagramChannel);
            boolean reuseAddr = this.isReuseAddress;
            if (reuseAddr != nioTransport.isReuseAddress()) {
                socket.setReuseAddress(reuseAddr);
            }
            socket.bind(localAddress);
            if (remoteAddress != null) {
                datagramChannel.connect(remoteAddress);
            }
            nioTransport.getChannelConfigurator().postConfigure(nioTransport, datagramChannel);
            this.preConfigure(newConnection);
            newConnection.setProcessor(this.getProcessor());
            newConnection.setProcessorSelector(this.getProcessorSelector());
            NIOChannelDistributor nioChannelDistributor = nioTransport.getNIOChannelDistributor();
            if (nioChannelDistributor == null) {
                throw new IllegalStateException("NIOChannelDistributor is null. Is Transport running?");
            }
            if (needFuture) {
                futureToReturn = this.makeCancellableFuture(newConnection);
                completionHandlerToPass = Futures.toCompletionHandler(futureToReturn, completionHandler);
            } else {
                completionHandlerToPass = completionHandler;
                futureToReturn = null;
            }
            nioChannelDistributor.registerChannelAsync(datagramChannel, 0, newConnection, new ConnectHandler((UDPNIOConnection)newConnection, completionHandlerToPass));
            return futureToReturn;
        }
        catch (Exception e) {
            if (newConnection != null) {
                newConnection.closeSilently();
            }
            if (completionHandler != null) {
                completionHandler.failed(e);
            }
            return needFuture ? ReadyFutureImpl.create(e) : null;
        }
    }

    public boolean isReuseAddress() {
        return this.isReuseAddress;
    }

    public void setReuseAddress(boolean isReuseAddress) {
        this.isReuseAddress = isReuseAddress;
    }

    public long getSyncConnectTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void setSyncConnectTimeout(long timeout, TimeUnit timeUnit) {
        this.connectionTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    protected void waitNIOFuture(FutureImpl<Connection> future, CompletionHandler<Connection> completionHandler) {
        try {
            future.get(this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Futures.notifyFailure(future, completionHandler, e);
        }
        catch (TimeoutException e) {
            Futures.notifyFailure(future, completionHandler, new IOException("Channel registration on Selector timeout!"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void abortConnection(UDPNIOConnection connection, CompletionHandler<Connection> completionHandler, Throwable failure) {
        connection.closeSilently();
        if (completionHandler != null) {
            completionHandler.failed(failure);
        }
    }

    public static Builder builder(UDPNIOTransport transport) {
        return new Builder().setTransport(transport);
    }

    public static class Builder
    extends AbstractSocketConnectorHandler.Builder<Builder> {
        private UDPNIOTransport transport;
        private Boolean reuseAddress;
        private Long timeout;
        private TimeUnit timeoutTimeunit;

        @Override
        public UDPNIOConnectorHandler build() {
            UDPNIOConnectorHandler handler = (UDPNIOConnectorHandler)super.build();
            if (this.reuseAddress != null) {
                handler.setReuseAddress(this.reuseAddress);
            }
            if (this.timeout != null) {
                handler.setSyncConnectTimeout(this.timeout, this.timeoutTimeunit);
            }
            return handler;
        }

        public Builder setTransport(UDPNIOTransport transport) {
            this.transport = transport;
            return this;
        }

        public Builder setReuseAddress(boolean reuseAddress) {
            this.reuseAddress = reuseAddress;
            return this;
        }

        public Builder setSyncConnectTimeout(long timeout, TimeUnit timeunit) {
            this.timeout = timeout;
            this.timeoutTimeunit = timeunit;
            return this;
        }

        @Override
        protected AbstractSocketConnectorHandler create() {
            if (this.transport == null) {
                throw new IllegalStateException("Unable to create UDPNIOConnectorHandler - transport is null");
            }
            return new UDPNIOConnectorHandler(this.transport);
        }
    }

    private static class EnableReadHandler
    extends IOEventLifeCycleListener.Adapter {
        private final CompletionHandler<Connection> completionHandler;

        private EnableReadHandler(CompletionHandler<Connection> completionHandler) {
            this.completionHandler = completionHandler;
        }

        @Override
        public void onReregister(Context context) throws IOException {
            this.onComplete(context, null);
        }

        @Override
        public void onNotRun(Context context) throws IOException {
            this.onComplete(context, null);
        }

        @Override
        public void onComplete(Context context, Object data) throws IOException {
            UDPNIOConnection connection = (UDPNIOConnection)context.getConnection();
            if (this.completionHandler != null) {
                this.completionHandler.completed(connection);
            }
            if (!connection.isStandalone()) {
                connection.enableInitialOpRead();
            }
        }

        @Override
        public void onError(Context context, Object description) throws IOException {
            context.getConnection().closeSilently();
        }
    }

    private final class ConnectHandler
    extends EmptyCompletionHandler<RegisterChannelResult> {
        private final UDPNIOConnection connection;
        private final CompletionHandler<Connection> completionHandler;

        private ConnectHandler(UDPNIOConnection connection, CompletionHandler<Connection> completionHandler) {
            this.connection = connection;
            this.completionHandler = completionHandler;
        }

        @Override
        public void completed(RegisterChannelResult result) {
            UDPNIOTransport transport = (UDPNIOTransport)UDPNIOConnectorHandler.this.transport;
            transport.registerChannelCompletionHandler.completed(result);
            try {
                this.connection.onConnect();
            }
            catch (Exception e) {
                UDPNIOConnectorHandler.abortConnection(this.connection, this.completionHandler, e);
            }
            if (this.connection.notifyReady()) {
                transport.fireIOEvent(IOEvent.CONNECTED, this.connection, new EnableReadHandler(this.completionHandler));
            }
        }

        @Override
        public void failed(Throwable throwable) {
            UDPNIOConnectorHandler.abortConnection(this.connection, this.completionHandler, throwable);
        }
    }
}

