/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class EmptyBodyTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new NoBodyResponseHandler();
    }

    @Test(groups={"standalone", "default_provider"})
    public void testEmptyBody() throws IOException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final AtomicBoolean err = new AtomicBoolean(false);
            final LinkedBlockingQueue queue = new LinkedBlockingQueue();
            final AtomicBoolean status = new AtomicBoolean(false);
            final AtomicInteger headers = new AtomicInteger(0);
            final CountDownLatch latch = new CountDownLatch(1);
            client.executeRequest(client.prepareGet(this.getTargetUrl()).build(), (AsyncHandler)new AsyncHandler<Object>(){

                public void onThrowable(Throwable t) {
                    Assert.fail((String)"Got throwable.", (Throwable)t);
                    err.set(true);
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart e) throws Exception {
                    byte[] bytes = e.getBodyPartBytes();
                    if (bytes.length != 0) {
                        String s = new String(bytes);
                        EmptyBodyTest.this.log.info("got part: {}", (Object)s);
                        EmptyBodyTest.this.log.warn("Sampling stacktrace.", new Throwable("trace that, we should not get called for empty body."));
                        queue.put(s);
                    }
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus e) throws Exception {
                    status.set(true);
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders e) throws Exception {
                    if (headers.incrementAndGet() == 2) {
                        throw new Exception("Analyze this.");
                    }
                    return AsyncHandler.STATE.CONTINUE;
                }

                public Object onCompleted() throws Exception {
                    latch.countDown();
                    return null;
                }
            });
            try {
                Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS), (String)"Latch failed.");
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Interrupted.", (Throwable)e);
            }
            Assert.assertFalse((boolean)err.get());
            Assert.assertEquals((int)queue.size(), (int)0);
            Assert.assertTrue((boolean)status.get());
            Assert.assertEquals((int)headers.get(), (int)1);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testPutEmptyBody() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Response response = (Response)client.preparePut(this.getTargetUrl()).setBody("String").execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)204);
            Assert.assertEquals((String)response.getResponseBody(), (String)"");
            Assert.assertTrue((boolean)(response.getResponseBodyAsStream() instanceof InputStream));
            Assert.assertEquals((int)response.getResponseBodyAsStream().read(), (int)-1);
        }
    }

    private class NoBodyResponseHandler
    extends AbstractHandler {
        private NoBodyResponseHandler() {
        }

        public void handle(String s, Request request, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
            if (!req.getMethod().equalsIgnoreCase("PUT")) {
                resp.setStatus(200);
            } else {
                resp.setStatus(204);
            }
            request.setHandled(true);
        }
    }
}

