/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.util.MiscUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class QueryParametersTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new QueryStringHandler();
    }

    @Test(groups={"standalone", "default_provider"})
    public void testQueryParameters() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ListenableFuture f = client.prepareGet("http://127.0.0.1:" + this.port1).addQueryParam("a", "1").addQueryParam("b", "2").execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader("a"), (String)"1");
            Assert.assertEquals((String)resp.getHeader("b"), (String)"2");
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testUrlRequestParametersEncoding() throws IOException, ExecutionException, InterruptedException {
        String URL = this.getTargetUrl() + "?q=";
        String REQUEST_PARAM = "github github \ngithub";
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            String requestUrl2 = URL + URLEncoder.encode(REQUEST_PARAM, "UTF-8");
            LoggerFactory.getLogger(QueryParametersTest.class).info("Executing request [{}] ...", (Object)requestUrl2);
            Response response = (Response)client.prepareGet(requestUrl2).execute().get();
            String s = URLDecoder.decode(response.getHeader("q"), "UTF-8");
            Assert.assertEquals((String)s, (String)REQUEST_PARAM);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void urlWithColonTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            String query = "test:colon:";
            Response response = (Response)client.prepareGet(String.format("http://127.0.0.1:%d/foo/test/colon?q=%s", this.port1, query)).setHeader("Content-Type", "text/html").execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getHeader("q"), (String)query);
        }
    }

    private class QueryStringHandler
    extends HandlerWrapper {
        private QueryStringHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if ("GET".equalsIgnoreCase(request.getMethod())) {
                String qs = request.getQueryString();
                if (MiscUtils.isNonEmpty((String)qs)) {
                    for (String qnv : qs.split("&")) {
                        String[] nv = qnv.split("=");
                        response.addHeader(nv[0], nv[1]);
                    }
                    response.setStatus(200);
                } else {
                    response.sendError(406);
                }
            } else {
                response.sendError(403);
            }
            r.setHandled(true);
        }
    }
}

