/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.async.ProviderUtil;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SimultaneousReadingAndWritingNPETestCase
extends AbstractBasicTest {
    private Thread serverThread;
    private TestServerSocket serverSocket;
    private int port;
    private static int NUMBER_OF_REQUESTS = 100;

    @BeforeMethod
    public void setUp() throws Exception {
        this.port = this.findFreePort();
        this.serverSocket = new TestServerSocket(this.port);
        this.serverThread = new Thread(this.serverSocket);
        this.serverThread.start();
        this.serverSocket.getLatch().await();
    }

    @Test
    public void testNPE() throws Exception {
        AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setAllowPoolingConnections(false).build());
        for (int i = 0; i < NUMBER_OF_REQUESTS; ++i) {
            ListenableFuture responseFuture = client.prepareGet("http://localhost:" + this.port).execute();
            Response response = (Response)responseFuture.get();
        }
    }

    @Override
    public AsyncHttpClient getAsyncHttpClient(AsyncHttpClientConfig config) {
        return ProviderUtil.grizzlyProvider(config);
    }

    private class TestServerSocket
    implements Runnable {
        private final int port;
        private final CountDownLatch latch = new CountDownLatch(1);

        public TestServerSocket(int port) {
            this.port = port;
        }

        @Override
        public void run() {
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(this.port);
                serverSocket.setReuseAddress(true);
                this.latch.countDown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (!Thread.interrupted()) {
                try {
                    Socket clientSocket = serverSocket.accept();
                    OutputStream os = clientSocket.getOutputStream();
                    os.write("HTTP/1.1 200 Ok".getBytes());
                    os.write("\n".getBytes());
                    os.write("Date: Fri, 09 Mar 2018 09:59:26 GMT".getBytes());
                    os.write("\n".getBytes());
                    os.write("Content-Length: 4".getBytes());
                    os.write("\n".getBytes());
                    os.write("\n".getBytes());
                    os.write("TEST".getBytes());
                    os.flush();
                    clientSocket.close();
                }
                catch (Exception exception) {}
            }
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }
    }
}

