/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.FluentStringsMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FluentStringsMapTest {
    @Test
    public void emptyTest() {
        FluentStringsMap map = new FluentStringsMap();
        Assert.assertTrue((boolean)map.keySet().isEmpty());
    }

    @Test
    public void normalTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("fOO", "bAr");
        map.add("Baz", Arrays.asList("fOo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("fOO", "Baz")));
        Assert.assertEquals((String)map.getFirstValue("fOO"), (String)"bAr");
        Assert.assertEquals((String)map.getJoinedValue("fOO", ", "), (String)"bAr");
        Assert.assertEquals((Collection)map.get((Object)"fOO"), Arrays.asList("bAr"));
        Assert.assertNull((Object)map.getFirstValue("foo"));
        Assert.assertNull((Object)map.getJoinedValue("foo", ", "));
        Assert.assertNull((Object)map.get((Object)"foo"));
        Assert.assertEquals((String)map.getFirstValue("Baz"), (String)"fOo");
        Assert.assertEquals((String)map.getJoinedValue("Baz", ", "), (String)"fOo, bar");
        Assert.assertEquals((Collection)map.get((Object)"Baz"), Arrays.asList("fOo", "bar"));
        Assert.assertNull((Object)map.getFirstValue("baz"));
        Assert.assertNull((Object)map.getJoinedValue("baz", ", "));
        Assert.assertNull((Object)map.get((Object)"baz"));
    }

    @Test
    public void addNullTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("fOO", "bAr");
        map.add(null, Arrays.asList("fOo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("fOO")));
        Assert.assertEquals((String)map.getFirstValue("fOO"), (String)"bAr");
        Assert.assertEquals((String)map.getJoinedValue("fOO", ", "), (String)"bAr");
        Assert.assertEquals((Collection)map.get((Object)"fOO"), Arrays.asList("bAr"));
        Assert.assertNull((Object)map.getFirstValue("foo"));
        Assert.assertNull((Object)map.getJoinedValue("foo", ", "));
        Assert.assertNull((Object)map.get((Object)"foo"));
        Assert.assertNull((Object)map.getFirstValue(null));
        Assert.assertNull((Object)map.getJoinedValue("Baz", ", "));
        Assert.assertNull((Object)map.get(null));
    }

    @Test
    public void sameKeyMultipleTimesTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "baz,foo");
        map.add("foo", Arrays.asList("bar"));
        map.add("foo", new String[]{"bla", "blubb"});
        map.add("fOO", "duh");
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "fOO")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"baz,foo");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"baz,foo, bar, bla, blubb");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("baz,foo", "bar", "bla", "blubb"));
        Assert.assertEquals((String)map.getFirstValue("fOO"), (String)"duh");
        Assert.assertEquals((String)map.getJoinedValue("fOO", ", "), (String)"duh");
        Assert.assertEquals((Collection)map.get((Object)"fOO"), Arrays.asList("duh"));
    }

    @Test
    public void emptyValueTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "");
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList(""));
    }

    @Test
    public void nullValueTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", (String)null);
        Assert.assertEquals((String)map.getFirstValue("foo"), null);
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), null);
        Assert.assertEquals((int)map.get((Object)"foo").size(), (int)1);
    }

    @Test
    public void mapConstructorTest() {
        LinkedHashMap<String, List<String>> headerMap = new LinkedHashMap<String, List<String>>();
        headerMap.put("foo", Arrays.asList("baz,foo"));
        headerMap.put("baz", Arrays.asList("bar"));
        headerMap.put("bar", Arrays.asList("bla", "blubb"));
        FluentStringsMap map = new FluentStringsMap(headerMap);
        headerMap.remove("foo");
        headerMap.remove("bar");
        headerMap.remove("baz");
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz", "bar")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"baz,foo");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"baz,foo");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("baz,foo"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"bla");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"bla, blubb");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("bla", "blubb"));
    }

    @Test
    public void mapConstructorNullTest() {
        FluentStringsMap map = new FluentStringsMap((Map)null);
        Assert.assertEquals((int)map.keySet().size(), (int)0);
    }

    @Test
    public void copyConstructorTest() {
        FluentStringsMap srcHeaders = new FluentStringsMap();
        srcHeaders.add("foo", "baz,foo");
        srcHeaders.add("baz", Arrays.asList("bar"));
        srcHeaders.add("bar", new String[]{"bla", "blubb"});
        FluentStringsMap map = new FluentStringsMap(srcHeaders);
        srcHeaders.delete("foo");
        srcHeaders.delete("bar");
        srcHeaders.delete("baz");
        Assert.assertTrue((boolean)srcHeaders.keySet().isEmpty());
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz", "bar")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"baz,foo");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"baz,foo");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("baz,foo"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"bla");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"bla, blubb");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("bla", "blubb"));
    }

    @Test
    public void copyConstructorNullTest() {
        FluentStringsMap map = new FluentStringsMap((FluentStringsMap)null);
        Assert.assertEquals((int)map.keySet().size(), (int)0);
    }

    @Test
    public void deleteTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.delete("baz");
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertNull((Object)map.getFirstValue("baz"));
        Assert.assertNull((Object)map.getJoinedValue("baz", ", "));
        Assert.assertNull((Object)map.get((Object)"baz"));
    }

    @Test
    public void deleteTestDifferentCase() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.delete("bAz");
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void deleteUndefinedKeyTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.delete("bar");
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void deleteNullTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.delete(null);
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void deleteAllArrayTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.deleteAll(new String[]{"baz", "Boo"});
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertNull((Object)map.getFirstValue("baz"));
        Assert.assertNull((Object)map.getJoinedValue("baz", ", "));
        Assert.assertNull((Object)map.get((Object)"baz"));
    }

    @Test
    public void deleteAllArrayDifferentCaseTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.deleteAll(new String[]{"Foo", "baz"});
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertNull((Object)map.getFirstValue("baz"));
        Assert.assertNull((Object)map.getJoinedValue("baz", ", "));
        Assert.assertNull((Object)map.get((Object)"baz"));
    }

    @Test
    public void deleteAllCollectionTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.deleteAll(Arrays.asList("baz", "foo"));
        Assert.assertEquals((Collection)map.keySet(), Collections.emptyList());
        Assert.assertNull((Object)map.getFirstValue("foo"));
        Assert.assertNull((Object)map.getJoinedValue("foo", ", "));
        Assert.assertNull((Object)map.get((Object)"foo"));
        Assert.assertNull((Object)map.getFirstValue("baz"));
        Assert.assertNull((Object)map.getJoinedValue("baz", ", "));
        Assert.assertNull((Object)map.get((Object)"baz"));
    }

    @Test
    public void deleteAllCollectionDifferentCaseTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.deleteAll(Arrays.asList("bAz", "fOO"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void deleteAllNullArrayTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.deleteAll((String[])null);
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void deleteAllNullCollectionTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.deleteAll((Collection)null);
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void replaceArrayTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.replaceWith("foo", new String[]{"blub", "bla"});
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"blub");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"blub, bla");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("blub", "bla"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void replaceCollectionTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.replaceWith("foo", Arrays.asList("blub", "bla"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"blub");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"blub, bla");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("blub", "bla"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void replaceDifferentCaseTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.replaceWith("Foo", Arrays.asList("blub", "bla"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz", "Foo")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        Assert.assertEquals((String)map.getFirstValue("Foo"), (String)"blub");
        Assert.assertEquals((String)map.getJoinedValue("Foo", ", "), (String)"blub, bla");
        Assert.assertEquals((Collection)map.get((Object)"Foo"), Arrays.asList("blub", "bla"));
    }

    @Test
    public void replaceUndefinedTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.replaceWith("bar", Arrays.asList("blub"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz", "bar")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"blub");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"blub");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("blub"));
    }

    @Test
    public void replaceNullTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.replaceWith(null, Arrays.asList("blub"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void replaceValueWithNullTest() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.replaceWith("baz", (Collection)null);
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertNull((Object)map.getFirstValue("baz"));
        Assert.assertNull((Object)map.getJoinedValue("baz", ", "));
        Assert.assertNull((Object)map.get((Object)"baz"));
    }

    @Test
    public void replaceAllMapTest1() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("bar", new String[]{"foo, bar", "baz"});
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "bar", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"foo, bar");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"foo, bar, baz");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("foo, bar", "baz"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.replaceAll(new FluentStringsMap().add("bar", "baz").add("Foo", new String[]{"blub", "bla"}));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "bar", "baz", "Foo")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"baz");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"baz");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("baz"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        Assert.assertEquals((String)map.getFirstValue("Foo"), (String)"blub");
        Assert.assertEquals((String)map.getJoinedValue("Foo", ", "), (String)"blub, bla");
        Assert.assertEquals((Collection)map.get((Object)"Foo"), Arrays.asList("blub", "bla"));
    }

    @Test
    public void replaceAllTest2() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("bar", new String[]{"foo, bar", "baz"});
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "bar", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"foo, bar");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"foo, bar, baz");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("foo, bar", "baz"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        LinkedHashMap<String, List<String>> newValues = new LinkedHashMap<String, List<String>>();
        newValues.put("bar", Arrays.asList("baz"));
        newValues.put("foo", null);
        map.replaceAll(newValues);
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("bar", "baz")));
        Assert.assertNull((Object)map.getFirstValue("foo"));
        Assert.assertNull((Object)map.getJoinedValue("foo", ", "));
        Assert.assertNull((Object)map.get((Object)"foo"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"baz");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"baz");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("baz"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void replaceAllNullTest1() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("bar", new String[]{"foo, bar", "baz"});
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "bar", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"foo, bar");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"foo, bar, baz");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("foo, bar", "baz"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.replaceAll((FluentStringsMap)null);
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "bar", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"foo, bar");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"foo, bar, baz");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("foo, bar", "baz"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void replaceAllNullTest2() {
        FluentStringsMap map = new FluentStringsMap();
        map.add("foo", "bar");
        map.add("bar", new String[]{"foo, bar", "baz"});
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "bar", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"foo, bar");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"foo, bar, baz");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("foo, bar", "baz"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.replaceAll((Map)null);
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "bar", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"foo, bar");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"foo, bar, baz");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("foo, bar", "baz"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }
}

