/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class Head302Test
extends AbstractBasicTest {
    @Test(groups={"standalone", "default_provider"})
    public void testHEAD302() throws IOException, BrokenBarrierException, InterruptedException, ExecutionException, TimeoutException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            Request request = new RequestBuilder("HEAD").setUrl("http://127.0.0.1:" + this.port1 + "/Test").build();
            client.executeRequest(request, (AsyncHandler)new AsyncCompletionHandlerBase(){

                public Response onCompleted(Response response) throws Exception {
                    l.countDown();
                    return super.onCompleted(response);
                }
            }).get(3L, TimeUnit.SECONDS);
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new Head302handler();
    }

    private class Head302handler
    extends AbstractHandler {
        private Head302handler() {
        }

        public void handle(String s, org.eclipse.jetty.server.Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if ("HEAD".equalsIgnoreCase(request.getMethod())) {
                if (request.getPathInfo().endsWith("_moved")) {
                    response.setStatus(200);
                } else {
                    response.setStatus(302);
                    response.setHeader("Location", request.getPathInfo() + "_moved");
                }
            } else {
                response.setStatus(403);
            }
        }
    }
}

