/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.generators;

import com.ning.http.client.Body;
import com.ning.http.client.BodyGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamBodyGenerator
implements BodyGenerator {
    private static final byte[] END_PADDING = "\r\n".getBytes();
    private static final byte[] ZERO = "0".getBytes();
    private final InputStream inputStream;
    private static final Logger logger = LoggerFactory.getLogger(InputStreamBodyGenerator.class);
    private boolean patchNettyChunkingIssue = false;

    public InputStreamBodyGenerator(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public Body createBody() throws IOException {
        if (this.inputStream.markSupported()) {
            this.inputStream.mark(0);
            this.inputStream.reset();
        }
        return new ISBody();
    }

    public void patchNettyChunkingIssue(boolean patchNettyChunkingIssue) {
        this.patchNettyChunkingIssue = patchNettyChunkingIssue;
    }

    protected class ISBody
    implements Body {
        private boolean eof = false;
        private int endDataCount = 0;
        private byte[] chunk;

        protected ISBody() {
        }

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public long read(ByteBuffer buffer) throws IOException {
            this.chunk = new byte[buffer.remaining() - 10];
            int read = -1;
            try {
                read = InputStreamBodyGenerator.this.inputStream.read(this.chunk);
            }
            catch (IOException ex) {
                logger.warn("Unable to read", (Throwable)ex);
            }
            if (InputStreamBodyGenerator.this.patchNettyChunkingIssue) {
                if (read == -1) {
                    if (!this.eof) {
                        ++this.endDataCount;
                        if (this.endDataCount == 2) {
                            this.eof = true;
                        }
                        if (this.endDataCount == 1) {
                            buffer.put(ZERO);
                        }
                        buffer.put(END_PADDING);
                        return buffer.position();
                    }
                    this.eof = false;
                    return -1L;
                }
                buffer.put(Integer.toHexString(read).getBytes());
                buffer.put(END_PADDING);
                buffer.put(this.chunk, 0, read);
                buffer.put(END_PADDING);
            } else if (read > 0) {
                buffer.put(this.chunk, 0, read);
            }
            return read;
        }

        @Override
        public void close() throws IOException {
            InputStreamBodyGenerator.this.inputStream.close();
        }
    }
}

