/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async.grizzly;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GrizzlyExpectingTimeoutTest
extends AbstractBasicTest {
    private static final String MSG = "Unauthorized without WWW-Authenticate header";

    protected String getExpectedTimeoutMessage() {
        return "Timeout exceeded";
    }

    @Override
    public AsyncHttpClient getAsyncHttpClient(AsyncHttpClientConfig config) {
        if (config == null) {
            config = new AsyncHttpClientConfig.Builder().build();
        }
        return new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new ExpectExceptionHandler();
    }

    @Test(groups={"standalone", "default_provider"})
    public void expectedTimeoutTest() throws IOException {
        final AtomicInteger counts = new AtomicInteger();
        int timeout = 100;
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setRequestTimeout(100).build());){
            ListenableFuture responseFuture = client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

                public Response onCompleted(Response response) throws Exception {
                    counts.incrementAndGet();
                    return response;
                }

                public void onThrowable(Throwable t) {
                    counts.incrementAndGet();
                    super.onThrowable(t);
                }
            });
            try {
                Response response = (Response)responseFuture.get();
                Assert.assertNull((Object)response);
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Interrupted.", (Throwable)e);
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof TimeoutException));
                Assert.assertEquals((String)e.getCause().getMessage(), (String)this.getExpectedTimeoutMessage());
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Interrupted.", (Throwable)e);
            }
            Assert.assertEquals((int)1, (int)counts.get(), (String)"result should be one");
        }
    }

    private class ExpectExceptionHandler
    extends AbstractHandler {
        private ExpectExceptionHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
            response.setStatus(401);
            AsyncContext continuation = request.startAsync();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        response.getOutputStream().print(GrizzlyExpectingTimeoutTest.MSG);
                        response.getOutputStream().flush();
                    }
                    catch (IOException e) {
                        GrizzlyExpectingTimeoutTest.this.log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }).start();
            baseRequest.setHandled(true);
        }
    }
}

