/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class ErrorResponseTest
extends AbstractBasicTest {
    static final String BAD_REQUEST_STR = "Very Bad Request! No cookies.";

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new ErrorHandler();
    }

    @Test(groups={"standalone", "default_provider"})
    public void testQueryParameters() throws Exception {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ListenableFuture f = client.prepareGet("http://127.0.0.1:" + this.port1 + "/foo").addHeader("Accepts", "*/*").execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)400);
            String respStr = resp.getResponseBody();
            Assert.assertEquals((String)BAD_REQUEST_STR, (String)respStr);
        }
    }

    private static class ErrorHandler
    extends AbstractHandler {
        private ErrorHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            try {
                Thread.sleep(210L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            response.setContentType("text/plain");
            response.setStatus(400);
            ServletOutputStream out = response.getOutputStream();
            out.write(ErrorResponseTest.BAD_REQUEST_STR.getBytes("UTF-8"));
            out.flush();
        }
    }
}

