/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.util.DateUtils;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class PerRequestTimeoutTest
extends AbstractBasicTest {
    private static final String MSG = "Enough is enough.";

    protected abstract void checkTimeoutMessage(String var1);

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new SlowHandler();
    }

    @Test(groups={"standalone", "default_provider"})
    public void testRequestTimeout() throws IOException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ListenableFuture responseFuture = ((AsyncHttpClient.BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setRequestTimeout(100)).execute();
            Response response = (Response)responseFuture.get(2000L, TimeUnit.MILLISECONDS);
            Assert.assertNull((Object)response);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TimeoutException));
            this.checkTimeoutMessage(e.getCause().getMessage());
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Timeout.", (Throwable)e);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testGlobalDefaultPerRequestInfiniteTimeout() throws IOException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setRequestTimeout(100).build());){
            ListenableFuture responseFuture = ((AsyncHttpClient.BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setRequestTimeout(-1)).execute();
            Response response = (Response)responseFuture.get();
            Assert.assertNotNull((Object)response);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TimeoutException));
            this.checkTimeoutMessage(e.getCause().getMessage());
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testGlobalRequestTimeout() throws IOException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setRequestTimeout(100).build());){
            ListenableFuture responseFuture = client.prepareGet(this.getTargetUrl()).execute();
            Response response = (Response)responseFuture.get(2000L, TimeUnit.MILLISECONDS);
            Assert.assertNull((Object)response);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TimeoutException));
            this.checkTimeoutMessage(e.getCause().getMessage());
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Timeout.", (Throwable)e);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testGlobalIdleTimeout() throws IOException {
        final long[] times = new long[]{-1L, -1L};
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setPooledConnectionIdleTimeout(2000).build());){
            ListenableFuture responseFuture = client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

                public Response onCompleted(Response response) throws Exception {
                    return response;
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                    times[0] = DateUtils.millisTime();
                    return super.onBodyPartReceived(content);
                }

                public void onThrowable(Throwable t) {
                    times[1] = DateUtils.millisTime();
                    super.onThrowable(t);
                }
            });
            Response response = (Response)responseFuture.get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((String)response.getResponseBody(), (String)"Enough is enough.Enough is enough.");
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            this.log.info(String.format("\n@%dms Last body part received\n@%dms Connection killed\n %dms difference.", times[0], times[1], times[1] - times[0]));
            Assert.fail((String)"Timeouted on idle.", (Throwable)e);
        }
    }

    private class SlowHandler
    extends HandlerWrapper {
        private SlowHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
            response.setStatus(200);
            final AsyncContext continuation = request.startAsync();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1500L);
                        response.getOutputStream().print(PerRequestTimeoutTest.MSG);
                        response.getOutputStream().flush();
                    }
                    catch (InterruptedException e) {
                        PerRequestTimeoutTest.this.log.error(e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        PerRequestTimeoutTest.this.log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }).start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                        response.getOutputStream().print(PerRequestTimeoutTest.MSG);
                        response.getOutputStream().flush();
                        continuation.complete();
                    }
                    catch (InterruptedException e) {
                        PerRequestTimeoutTest.this.log.error(e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        PerRequestTimeoutTest.this.log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }).start();
            baseRequest.setHandled(true);
        }
    }
}

