/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public abstract class PutLargeFileTest
extends AbstractBasicTest {
    private File largeFile;
    private static final File TMP = new File(System.getProperty("java.io.tmpdir"), "ahc-tests-" + UUID.randomUUID().toString().substring(0, 8));

    @Test(groups={"standalone", "default_provider"}, enabled=true)
    public void testPutLargeFile() throws Exception {
        byte[] bytes = "RatherLargeFileRatherLargeFileRatherLargeFileRatherLargeFile".getBytes("UTF-16");
        long repeats = 0x6400000 / bytes.length + 1;
        this.largeFile = PutLargeFileTest.createTempFile(bytes, (int)repeats);
        int timeout = (int)(this.largeFile.length() / 1000L);
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setConnectTimeout(timeout).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            AsyncHttpClient.BoundRequestBuilder rb = client.preparePut(this.getTargetUrl());
            rb.setBody(this.largeFile);
            Response response = (Response)rb.execute().get();
            Assert.assertEquals((int)200, (int)response.getStatusCode());
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testPutSmallFile() throws Exception {
        byte[] bytes = "RatherLargeFileRatherLargeFileRatherLargeFileRatherLargeFile".getBytes("UTF-16");
        long repeats = 1024 / bytes.length + 1;
        this.largeFile = PutLargeFileTest.createTempFile(bytes, (int)repeats);
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            AsyncHttpClient.BoundRequestBuilder rb = client.preparePut(this.getTargetUrl());
            rb.setBody(this.largeFile);
            Response response = (Response)rb.execute().get();
            Assert.assertEquals((int)200, (int)response.getStatusCode());
        }
    }

    @AfterMethod
    public void after() {
        this.largeFile.delete();
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new AbstractHandler(){

            public void handle(String arg0, Request arg1, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                ServletInputStream in = req.getInputStream();
                byte[] b = new byte[8092];
                int count = -1;
                int total = 0;
                while ((count = in.read(b)) != -1) {
                    total += count;
                }
                System.err.println("consumed " + total + " bytes.");
                resp.setStatus(200);
                resp.getOutputStream().flush();
                resp.getOutputStream().close();
                arg1.setHandled(true);
            }
        };
    }

    public static File createTempFile(byte[] pattern, int repeat) throws IOException {
        TMP.mkdirs();
        TMP.deleteOnExit();
        File tmpFile = File.createTempFile("tmpfile-", ".data", TMP);
        tmpFile.deleteOnExit();
        PutLargeFileTest.write(pattern, repeat, tmpFile);
        return tmpFile;
    }

    public static void write(byte[] pattern, int repeat, File file) throws IOException {
        file.deleteOnExit();
        file.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(file);){
            for (int i = 0; i < repeat; ++i) {
                out.write(pattern);
            }
        }
    }
}

