/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public abstract class AsyncStreamLifecycleTest
extends AbstractBasicTest {
    private ExecutorService executorService = Executors.newFixedThreadPool(2);

    @Override
    @AfterClass
    public void tearDownGlobal() throws Exception {
        super.tearDownGlobal();
        this.executorService.shutdownNow();
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new AbstractHandler(){

            public void handle(String s, Request request, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                resp.setContentType("text/plain;charset=utf-8");
                resp.setStatus(200);
                final AsyncContext continuation = req.startAsync();
                final PrintWriter writer = resp.getWriter();
                AsyncStreamLifecycleTest.this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            AsyncStreamLifecycleTest.this.log.error("Failed to sleep for 100 ms.", (Throwable)e);
                        }
                        AsyncStreamLifecycleTest.this.log.info("Delivering part1.");
                        writer.write("part1");
                        writer.flush();
                    }
                });
                AsyncStreamLifecycleTest.this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException e) {
                            AsyncStreamLifecycleTest.this.log.error("Failed to sleep for 200 ms.", (Throwable)e);
                        }
                        AsyncStreamLifecycleTest.this.log.info("Delivering part2.");
                        writer.write("part2");
                        writer.flush();
                        continuation.complete();
                    }
                });
                request.setHandled(true);
            }
        };
    }

    @Test(groups={"standalone", "default_provider"})
    public void testStream() throws IOException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final AtomicBoolean err = new AtomicBoolean(false);
            final LinkedBlockingQueue queue = new LinkedBlockingQueue();
            final AtomicBoolean status = new AtomicBoolean(false);
            final AtomicInteger headers = new AtomicInteger(0);
            final CountDownLatch latch = new CountDownLatch(1);
            client.executeRequest(client.prepareGet(this.getTargetUrl()).build(), (AsyncHandler)new AsyncHandler<Object>(){

                public void onThrowable(Throwable t) {
                    Assert.fail((String)"Got throwable.", (Throwable)t);
                    err.set(true);
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart e) throws Exception {
                    String s = new String(e.getBodyPartBytes());
                    AsyncStreamLifecycleTest.this.log.info("got part: {}", (Object)s);
                    if (s.isEmpty()) {
                        AsyncStreamLifecycleTest.this.log.warn("Sampling stacktrace.", new Throwable("trace that, we should not get called for empty body."));
                    }
                    queue.put(s);
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus e) throws Exception {
                    status.set(true);
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders e) throws Exception {
                    if (headers.incrementAndGet() == 2) {
                        throw new Exception("Analyze this.");
                    }
                    return AsyncHandler.STATE.CONTINUE;
                }

                public Object onCompleted() throws Exception {
                    latch.countDown();
                    return null;
                }
            });
            try {
                Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS), (String)"Latch failed.");
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Interrupted.", (Throwable)e);
            }
            Assert.assertFalse((boolean)err.get());
            Assert.assertEquals((int)queue.size(), (int)2);
            Assert.assertTrue((boolean)queue.contains("part1"));
            Assert.assertTrue((boolean)queue.contains("part2"));
            Assert.assertTrue((boolean)status.get());
            Assert.assertEquals((int)headers.get(), (int)1);
        }
    }
}

