/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.async.FilePartLargeFileTest;
import com.ning.http.client.multipart.FilePart;
import com.ning.http.client.multipart.Part;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class FastUnauthorizedUploadTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                resp.setStatus(401);
                resp.getOutputStream().flush();
                resp.getOutputStream().close();
                baseRequest.setHandled(true);
            }
        };
    }

    @Test(groups={"standalone", "default_provider"}, enabled=true)
    public void testUnauthorizedWhileUploading() throws Exception {
        byte[] bytes = "RatherLargeFileRatherLargeFileRatherLargeFileRatherLargeFile".getBytes(StandardCharsets.UTF_16);
        long repeats = 0x100000 / bytes.length + 1;
        File largeFile = FilePartLargeFileTest.createTempFile(bytes, (int)repeats);
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            AsyncHttpClient.BoundRequestBuilder rb = client.preparePut(this.getTargetUrl());
            rb.addBodyPart((Part)new FilePart("test", largeFile, "application/octet-stream", StandardCharsets.UTF_8));
            Response response = (Response)rb.execute().get();
            Assert.assertEquals((int)401, (int)response.getStatusCode());
        }
    }
}

