/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class RedirectTimeoutTest
extends AbstractBasicTest {
    private static final String REDIRECT_PATH = "/redirectPath";
    private static final String FINAL_PATH = "/finalPath";
    private static final String PAYLOAD = "Ok";
    private static final String GLOBAL_REQUEST_TIMEOUT = "5000";
    private static final String REQUEST_TIMEOUT = "2000";
    private static final String TIMEOUT_ERROR_MESSAGE = "Timeout exceeded";
    private static long SLEEP_TIME;
    private static final long DELTA = 800L;
    private AsyncHttpClientConfig clientConfig;

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new PostRedirectGetHandler();
    }

    @Override
    public AsyncHttpClient getAsyncHttpClient(AsyncHttpClientConfig config) {
        return new AsyncHttpClient(config);
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.clientConfig = new AsyncHttpClientConfig.Builder().setFollowRedirect(true).setRequestTimeout(Integer.valueOf(GLOBAL_REQUEST_TIMEOUT).intValue()).build();
    }

    @DataProvider(name="timeout")
    public Object[][] createData1() {
        return new Object[][]{{GLOBAL_REQUEST_TIMEOUT}, {REQUEST_TIMEOUT}};
    }

    @Test(dataProvider="timeout")
    public void testRequestTimeout(String timeout) {
        SLEEP_TIME = Long.valueOf(timeout) * 2L;
        AsyncHttpClient client = this.getAsyncHttpClient(this.clientConfig);
        Request request = ((RequestBuilder)new RequestBuilder("GET").setRequestTimeout(Integer.valueOf(timeout).intValue())).setUrl(this.getTargetUrl().concat(REDIRECT_PATH)).build();
        ListenableFuture responseFuture = client.executeRequest(request);
        this.assertTimeout((ListenableFuture<Response>)responseFuture, timeout);
    }

    private void assertTimeout(ListenableFuture<Response> responseFuture, String timeout) {
        try {
            responseFuture.get(Long.valueOf(timeout) + 800L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"TimeoutException must be thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(TIMEOUT_ERROR_MESSAGE));
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Future timed out so Grizzly didn't honor the given request timeout. ", (Throwable)e);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException should not be thrown ", (Throwable)e);
        }
    }

    public static class PostRedirectGetHandler
    extends AbstractHandler {
        public void handle(String pathInContext, org.eclipse.jetty.server.Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            if (httpRequest.getRequestURI().endsWith(RedirectTimeoutTest.REDIRECT_PATH)) {
                httpResponse.setStatus(302);
                httpResponse.setHeader("Location", RedirectTimeoutTest.FINAL_PATH);
            } else if (httpRequest.getRequestURI().endsWith(RedirectTimeoutTest.FINAL_PATH)) {
                try {
                    Thread.sleep(SLEEP_TIME);
                    httpResponse.setStatus(200);
                    httpResponse.getOutputStream().print(RedirectTimeoutTest.PAYLOAD);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            httpResponse.getOutputStream().flush();
        }
    }
}

