/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.util.UTF8UrlDecoder;
import com.ning.http.util.UTF8UrlEncoder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UTF8UrlCodecTest {
    @Test(groups={"fast"})
    public void testBasics() {
        Assert.assertEquals((String)UTF8UrlEncoder.encodeQueryElement((String)"foobar"), (String)"foobar");
        Assert.assertEquals((String)UTF8UrlEncoder.encodeQueryElement((String)"a&b"), (String)"a%26b");
        Assert.assertEquals((String)UTF8UrlEncoder.encodeQueryElement((String)"a+b"), (String)"a%2Bb");
    }

    @Test(groups={"fast"})
    public void testNonBmp() {
        Assert.assertEquals((String)UTF8UrlEncoder.encodeQueryElement((String)"\ud83d\udca9"), (String)"%F0%9F%92%A9");
        Assert.assertEquals((String)UTF8UrlEncoder.encodeQueryElement((String)"\ud84c\uddc8 \ud84f\udfef"), (String)"%F0%A3%87%88%20%F0%A3%BF%AF");
        Assert.assertEquals((String)UTF8UrlEncoder.encodeQueryElement((String)"\udb80\udc01"), (String)"%F3%B0%80%81");
    }

    @Test(groups={"fast"})
    public void testDecodeBasics() {
        Assert.assertEquals((String)UTF8UrlDecoder.decode((String)"foobar").toString(), (String)"foobar");
        Assert.assertEquals((String)UTF8UrlDecoder.decode((String)"a&b").toString(), (String)"a&b");
        Assert.assertEquals((String)UTF8UrlDecoder.decode((String)"a+b").toString(), (String)"a b");
        Assert.assertEquals((String)UTF8UrlDecoder.decode((String)"+").toString(), (String)" ");
        Assert.assertEquals((String)UTF8UrlDecoder.decode((String)"%20").toString(), (String)" ");
        Assert.assertEquals((String)UTF8UrlDecoder.decode((String)"%25").toString(), (String)"%");
        Assert.assertEquals((String)UTF8UrlDecoder.decode((String)"+%20x").toString(), (String)"  x");
    }

    @Test(groups={"fast"})
    public void testDecodeTooShort() {
        try {
            UTF8UrlDecoder.decode((String)"%2");
            Assert.assertTrue((boolean)false, (String)"No exception thrown on illegal encoding length");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((String)ex.getMessage(), (String)"UTF8UrlDecoder: Incomplete trailing escape (%) pattern");
        }
        catch (StringIndexOutOfBoundsException ex) {
            Assert.assertTrue((boolean)false, (String)"String Index Out of Bound thrown, but should be IllegalArgument");
        }
    }
}

