/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class BodyChunkTest
extends AbstractBasicTest {
    private static final String MY_MESSAGE = "my message";

    @Test(groups={"standalone", "default_provider"})
    public void negativeContentTypeTest() throws Throwable {
        AsyncHttpClientConfig.Builder confbuilder = new AsyncHttpClientConfig.Builder();
        confbuilder = confbuilder.setConnectTimeout(100);
        confbuilder = confbuilder.setMaxConnections(50);
        confbuilder = confbuilder.setRequestTimeout(300000);
        try (AsyncHttpClient client = this.getAsyncHttpClient(confbuilder.build());){
            RequestBuilder requestBuilder = new RequestBuilder("POST").setUrl(this.getTargetUrl()).setHeader("Content-Type", "message/rfc822");
            requestBuilder.setBody((BodyGenerator)new InputStreamBodyGenerator((InputStream)new ByteArrayInputStream(MY_MESSAGE.getBytes())));
            ListenableFuture future = client.executeRequest(requestBuilder.build());
            System.out.println("waiting for response");
            Response response = (Response)future.get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getResponseBody(), (String)MY_MESSAGE);
        }
    }
}

