/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.Realm;
import com.ning.http.client.uri.Uri;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RealmTest {
    @Test(groups={"fast"})
    public void testClone() {
        Realm.RealmBuilder builder = new Realm.RealmBuilder();
        builder.setPrincipal("user").setPassword("pass");
        builder.setCharset(StandardCharsets.UTF_16).setUsePreemptiveAuth(true);
        builder.setRealmName("realm").setAlgorithm("algo");
        builder.setScheme(Realm.AuthScheme.BASIC);
        Realm orig = builder.build();
        Realm clone = new Realm.RealmBuilder().clone(orig).build();
        Assert.assertEquals((String)clone.getPrincipal(), (String)orig.getPrincipal());
        Assert.assertEquals((String)clone.getPassword(), (String)orig.getPassword());
        Assert.assertEquals((Object)clone.getCharset(), (Object)orig.getCharset());
        Assert.assertEquals((boolean)clone.getUsePreemptiveAuth(), (boolean)orig.getUsePreemptiveAuth());
        Assert.assertEquals((String)clone.getRealmName(), (String)orig.getRealmName());
        Assert.assertEquals((String)clone.getAlgorithm(), (String)orig.getAlgorithm());
        Assert.assertEquals((Object)clone.getScheme(), (Object)orig.getScheme());
    }

    @Test(groups={"fast"})
    public void testOldDigestEmptyString() {
        String qop = "";
        this.testOldDigest(qop);
    }

    @Test(groups={"fast"})
    public void testOldDigestNull() {
        String qop = null;
        this.testOldDigest(qop);
    }

    private void testOldDigest(String qop) {
        String user = "user";
        String pass = "pass";
        String realm = "realm";
        String nonce = "nonce";
        String method = "GET";
        Uri uri = Uri.create((String)"http://ahc.io/foo");
        Realm.RealmBuilder builder = new Realm.RealmBuilder();
        builder.setPrincipal(user).setPassword(pass);
        builder.setNonce(nonce);
        builder.setUri(uri);
        builder.setMethodName(method);
        builder.setRealmName(realm);
        builder.setQop(qop);
        builder.setScheme(Realm.AuthScheme.DIGEST);
        Realm orig = builder.build();
        String ha1 = this.getMd5(user + ":" + realm + ":" + pass);
        String ha2 = this.getMd5(method + ":" + uri.getPath());
        String expectedResponse = this.getMd5(ha1 + ":" + nonce + ":" + ha2);
        Assert.assertEquals((String)expectedResponse, (String)orig.getResponse());
    }

    @Test(groups={"fast"})
    public void testStrongDigest() {
        String user = "user";
        String pass = "pass";
        String realm = "realm";
        String nonce = "nonce";
        String method = "GET";
        Uri uri = Uri.create((String)"http://ahc.io/foo");
        String qop = "auth";
        Realm.RealmBuilder builder = new Realm.RealmBuilder();
        builder.setPrincipal(user).setPassword(pass);
        builder.setNonce(nonce);
        builder.setUri(uri);
        builder.setMethodName(method);
        builder.setRealmName(realm);
        builder.setQop(qop);
        builder.setScheme(Realm.AuthScheme.DIGEST);
        Realm orig = builder.build();
        String nc = orig.getNc();
        String cnonce = orig.getCnonce();
        String ha1 = this.getMd5(user + ":" + realm + ":" + pass);
        String ha2 = this.getMd5(method + ":" + uri.getPath());
        String expectedResponse = this.getMd5(ha1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + ha2);
        Assert.assertEquals((String)expectedResponse, (String)orig.getResponse());
    }

    private String getMd5(String what) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(what.getBytes(StandardCharsets.ISO_8859_1));
            byte[] hash = md.digest();
            BigInteger bi = new BigInteger(1, hash);
            String result = bi.toString(16);
            if (result.length() % 2 != 0) {
                return "0" + result;
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

