/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.util.AsyncHttpProviderUtils;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class RemoteSiteTest
extends AbstractBasicTest {
    public static final String URL = "http://google.com?q=";
    public static final String REQUEST_PARAM = "github github \ngithub";

    @Test(groups={"online", "default_provider"})
    public void testGoogleCom() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setRequestTimeout(10000).build());){
            Response response = (Response)client.prepareGet("http://www.google.com/").execute().get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)response);
        }
    }

    @Test(groups={"online", "default_provider"}, enabled=false)
    public void testMicrosoftCom() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setRequestTimeout(10000).build());){
            Response response = (Response)client.prepareGet("http://microsoft.com/").execute().get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)301);
        }
    }

    @Test(groups={"online", "default_provider"}, enabled=false)
    public void testWwwMicrosoftCom() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setRequestTimeout(10000).build());){
            Response response = (Response)client.prepareGet("http://www.microsoft.com/").execute().get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)302);
        }
    }

    @Test(groups={"online", "default_provider"}, enabled=false)
    public void testUpdateMicrosoftCom() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setRequestTimeout(10000).build());){
            Response response = (Response)client.prepareGet("http://update.microsoft.com/").execute().get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)302);
        }
    }

    @Test(groups={"online", "default_provider"})
    public void testGoogleComWithTimeout() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setRequestTimeout(10000).build());){
            Response response = (Response)client.prepareGet("http://google.com/").execute().get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)response);
            Assert.assertTrue((response.getStatusCode() == 301 || response.getStatusCode() == 302 ? 1 : 0) != 0);
        }
    }

    @Test(groups={"online", "default_provider"})
    public void asyncStatusHEADContentLenghtTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setFollowRedirect(true).build());){
            final CountDownLatch l = new CountDownLatch(1);
            Request request = new RequestBuilder("HEAD").setUrl("http://www.google.com/").build();
            client.executeRequest(request, (AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    Assert.assertEquals((int)response.getStatusCode(), (int)200);
                    l.countDown();
                    return response;
                }
            }).get();
            if (!l.await(5L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"online", "default_provider"}, enabled=false)
    public void invalidStreamTest2() throws Throwable {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setRequestTimeout(10000).setFollowRedirect(true).setAllowPoolingConnections(false).setMaxRedirects(6).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            Response response = (Response)client.prepareGet("http://bit.ly/aUjTtG").execute().get();
            if (response != null) {
                System.out.println(response);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.assertNotNull((Object)t.getCause());
            Assert.assertEquals((String)t.getCause().getMessage(), (String)"invalid version format: ICY");
        }
    }

    @Test(groups={"online", "default_provider"})
    public void asyncFullBodyProperlyRead() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Response r = (Response)client.prepareGet("http://www.cyberpresse.ca/").execute().get();
            InputStream stream = r.getResponseBodyAsStream();
            int available = stream.available();
            int[] lengthWrapper = new int[1];
            AsyncHttpProviderUtils.readFully((InputStream)stream, (int[])lengthWrapper);
            int byteToRead = lengthWrapper[0];
            Assert.assertEquals((int)available, (int)byteToRead);
        }
    }

    @Test(groups={"online", "default_provider"})
    public void testUrlRequestParametersEncoding() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            String requestUrl2 = URL + URLEncoder.encode(REQUEST_PARAM, "UTF-8");
            this.log.info(String.format("Executing request [%s] ...", requestUrl2));
            Response response = (Response)client.prepareGet(requestUrl2).execute().get();
            Assert.assertTrue((response.getStatusCode() == 301 || response.getStatusCode() == 302 ? 1 : 0) != 0);
        }
    }

    @Test(groups={"online", "default_provider"})
    public void stripQueryStringTest() throws Throwable {
        AsyncHttpClientConfig cg = new AsyncHttpClientConfig.Builder().setFollowRedirect(true).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(cg);){
            Response response = (Response)client.prepareGet("http://www.freakonomics.com/?p=55846").execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"online", "default_provider"})
    public void evilCoookieTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            RequestBuilder builder2 = new RequestBuilder("GET");
            builder2.setFollowRedirects(true);
            builder2.setUrl("http://www.google.com/");
            builder2.addHeader("Content-Type", "text/plain");
            builder2.addCookie(new Cookie("evilcookie", "test", false, ".google.com", "/", 10L, false, false));
            Request request2 = builder2.build();
            Response response = (Response)client.executeRequest(request2).get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"online", "default_provider"}, enabled=false)
    public void testAHC62Com() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setFollowRedirect(true).build());){
            Response response = (Response)client.prepareGet("http://api.crunchbase.com/v/1/financial-organization/kinsey-hills-group.js").execute((AsyncHandler)new AsyncHandler<Response>(){
                private Response.ResponseBuilder builder = new Response.ResponseBuilder();

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    System.out.println(bodyPart.getBodyPartBytes().length);
                    this.builder.accumulate(bodyPart);
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    this.builder.accumulate(responseStatus);
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
                    this.builder.accumulate(headers);
                    return AsyncHandler.STATE.CONTINUE;
                }

                public Response onCompleted() throws Exception {
                    return this.builder.build();
                }
            }).get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)response);
            Assert.assertTrue((response.getResponseBody().length() >= 3870 ? 1 : 0) != 0);
        }
    }
}

