/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.providers.grizzly.FeedableBodyGenerator;
import java.io.IOException;
import java.io.InputStream;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonBlockingInputStreamFeeder
extends FeedableBodyGenerator.NonBlockingFeeder {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonBlockingInputStreamFeeder.class);
    private static final int DEFAULT_INTERNAL_BUFFER_SIZE = 8192;
    private final InputStream content;
    private boolean isDone;
    private int internalBufferSize;

    public NonBlockingInputStreamFeeder(FeedableBodyGenerator feedableBodyGenerator, InputStream content) {
        this(feedableBodyGenerator, content, 8192);
    }

    public NonBlockingInputStreamFeeder(FeedableBodyGenerator feedableBodyGenerator, InputStream content, int internalBufferSize) {
        super(feedableBodyGenerator);
        this.content = content;
        this.internalBufferSize = internalBufferSize;
    }

    @Override
    public void canFeed() throws IOException {
        byte[] bytesIn = new byte[this.internalBufferSize];
        int read = this.content.read(bytesIn);
        if (read == -1) {
            this.isDone = true;
            this.feed(Buffers.EMPTY_BUFFER, true);
            return;
        }
        if (read == 0) {
            this.feed(Buffers.EMPTY_BUFFER, false);
            return;
        }
        Buffer b = Buffers.wrap((MemoryManager)MemoryManager.DEFAULT_MEMORY_MANAGER, (byte[])bytesIn, (int)0, (int)read);
        this.feed(b, false);
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public boolean isReady() {
        return !this.isDone;
    }

    @Override
    public void notifyReadyToFeed(FeedableBodyGenerator.NonBlockingFeeder.ReadyToFeedListener listener) {
        if (this.isReady()) {
            listener.ready();
        }
    }

    @Override
    public void reset() {
        this.isDone = false;
        if (this.content.markSupported()) {
            block3: {
                try {
                    this.content.reset();
                }
                catch (IOException ioe) {
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug("Unable to reset the input stream: {}", (Object)ioe.getMessage());
                }
            }
            this.content.mark(0);
        }
        super.reset();
    }
}

