/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.proxy.ConnectHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class NtlmHttpProxyToHttpsTest
extends AbstractBasicTest {
    private Server server2;

    @Override
    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        this.server.stop();
        this.server2.stop();
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        this.server2 = new Server();
        this.port1 = this.findFreePort();
        this.port2 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        this.server.setHandler((Handler)this.configureHandler());
        this.server.start();
        HttpConfiguration https_config = new HttpConfiguration();
        https_config.setSecureScheme("https");
        https_config.setSecurePort(this.port2);
        https_config.setOutputBufferSize(32768);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setStsMaxAge(2000L);
        src.setStsIncludeSubDomains(true);
        https_config.addCustomizer((HttpConfiguration.Customizer)src);
        ClassLoader cl = this.getClass().getClassLoader();
        SslContextFactory sslContextFactory = new SslContextFactory();
        URL cacertsUrl = cl.getResource("ssltest-cacerts.jks");
        String trustStoreFile = new File(cacertsUrl.toURI()).getAbsolutePath();
        sslContextFactory.setTrustStorePath(trustStoreFile);
        sslContextFactory.setTrustStorePassword("changeit");
        sslContextFactory.setTrustStoreType("JKS");
        this.log.info("SSL certs path: {}", (Object)trustStoreFile);
        URL keystoreUrl = cl.getResource("ssltest-keystore.jks");
        String keyStoreFile = new File(keystoreUrl.toURI()).getAbsolutePath();
        sslContextFactory.setKeyStorePath(keyStoreFile);
        sslContextFactory.setKeyStorePassword("changeit");
        sslContextFactory.setKeyStoreType("JKS");
        this.log.info("SSL keystore path: {}", (Object)keyStoreFile);
        ServerConnector connector = new ServerConnector(this.server2, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
        connector.setHost("127.0.0.1");
        connector.setPort(this.port2);
        this.server2.addConnector((Connector)connector);
        this.server2.setHandler((Handler)new AbstractBasicTest.EchoHandler());
        this.server2.start();
        this.log.info("Local Proxy Server (" + this.port1 + "), HTTPS Server (" + this.port2 + ") started successfully");
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new ConnectHandler((Handler)new AbstractBasicTest.EchoHandler()){
            AtomicInteger state;
            AtomicBoolean authComplete;
            {
                this.state = new AtomicInteger(1);
                this.authComplete = new AtomicBoolean(false);
            }

            public void handle(String pathInContext, org.eclipse.jetty.server.Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
                String authorization = httpRequest.getHeader("Proxy-Authorization");
                boolean asExpected = false;
                switch (this.state.getAndIncrement()) {
                    case 1: {
                        if (!authorization.equals("NTLM TlRMTVNTUAABAAAAAYIIogAAAAAoAAAAAAAAACgAAAAFASgKAAAADw==")) break;
                        httpResponse.setStatus(407);
                        httpResponse.setHeader("Proxy-Authenticate", "NTLM TlRMTVNTUAACAAAAAAAAACgAAAABggAAU3J2Tm9uY2UAAAAAAAAAAA==");
                        asExpected = true;
                        break;
                    }
                    case 2: {
                        if (!authorization.equals("NTLM TlRMTVNTUAADAAAAGAAYAEgAAAAYABgAYAAAABQAFAB4AAAADAAMAIwAAAASABIAmAAAAAAAAACqAAAAAYIAAgUBKAoAAAAPrYfKbe/jRoW5xDxHeoxC1gBmfWiS5+iX4OAN4xBKG/IFPwfH3agtPEia6YnhsADTVQBSAFMAQQAtAE0ASQBOAE8AUgBaAGEAcABoAG8AZABMAGkAZwBoAHQAQwBpAHQAeQA=")) break;
                        httpResponse.setStatus(200);
                        super.handleConnect(request, httpRequest, httpResponse, request.getRequestURI());
                        asExpected = true;
                        this.authComplete.getAndSet(true);
                        break;
                    }
                }
                if (!asExpected) {
                    httpResponse.setStatus(403);
                }
                if (this.authComplete.get() && HttpMethod.GET.is(httpRequest.getMethod())) {
                    super.handle(pathInContext, request, httpRequest, httpResponse);
                }
                httpResponse.setContentLength(0);
                httpResponse.getOutputStream().flush();
                httpResponse.getOutputStream().close();
            }
        };
    }

    @Test
    public void httpProxyToHttpsTargetTest() throws IOException, InterruptedException, ExecutionException, NoSuchAlgorithmException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setAcceptAnyCertificate(true).build());){
            Request request = new RequestBuilder("GET").setProxyServer(this.ntlmProxy()).setUrl(this.getTargetUrl2()).build();
            ListenableFuture responseFuture = client.executeRequest(request);
            Response response = (Response)responseFuture.get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)("127.0.0.1:" + this.port2), (String)response.getHeader("x-host"));
        }
    }

    private ProxyServer ntlmProxy() throws UnknownHostException {
        ProxyServer proxyServer = new ProxyServer("127.0.0.1", this.port1, "Zaphod", "Beeblebrox").setNtlmDomain("Ursa-Minor");
        proxyServer.setNtlmHost("LightCity");
        proxyServer.setScheme(Realm.AuthScheme.NTLM);
        return proxyServer;
    }
}

