/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class ComplexClientTest
extends AbstractBasicTest {
    @Test(groups={"standalone", "default_provider"})
    public void multipleRequestsTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            String body = "hello there";
            Response response = (Response)client.preparePost(this.getTargetUrl()).setBody(body).setHeader("Content-Type", "text/html").execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)body);
            response = (Response)client.preparePost(this.getTargetUrl()).setBody(body).setHeader("Content-Type", "text/html").execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)body);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void urlWithoutSlashTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            String body = "hello there";
            Response response = (Response)client.preparePost(String.format("http://127.0.0.1:%d/foo/test", this.port1)).setBody(body).setHeader("Content-Type", "text/html").execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)body);
        }
    }
}

