/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.multipart.ByteArrayPart;
import com.ning.http.client.multipart.FilePart;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.multipart.StringPart;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.zip.GZIPInputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class MultipartUploadTest
extends AbstractBasicTest {
    private String servletEndpointRedirectUrl;
    public static byte[] GZIPTEXT = new byte[]{31, -117, 8, 8, 11, 43, 79, 75, 0, 3, 104, 101, 108, 108, 111, 46, 116, 120, 116, 0, -53, 72, -51, -55, -55, -25, 2, 0, 32, 48, 58, 54, 6, 0, 0, 0};

    @BeforeClass
    public void setUp() throws Exception {
        this.server = new Server();
        this.port1 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("localhost");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.addServlet(new ServletHolder((Servlet)new MockMultipartUploadServlet()), "/upload/*");
        this.server.setHandler((Handler)context);
        this.server.start();
        this.servletEndpointRedirectUrl = "http://localhost:" + this.port1;
    }

    @AfterClass
    public void stop() {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            System.err.print("Error stopping servlet tester");
            e.printStackTrace();
        }
    }

    private File getClasspathFile(String file) throws FileNotFoundException {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = MultipartUploadTest.class.getClassLoader();
        }
        URL resourceUrl = cl.getResource(file);
        try {
            return new File(new URI(resourceUrl.toString()).getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            throw new FileNotFoundException(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendingSmallFilesAndByteArray() throws IOException, InterruptedException, ExecutionException {
        String expectedContents = "filecontent: hello";
        String expectedContents2 = "gzipcontent: hello";
        String expectedContents3 = "filecontent: hello2";
        String testResource1 = "textfile.txt";
        String testResource2 = "gzip.txt.gz";
        String testResource3 = "textfile2.txt";
        File testResource1File = null;
        try {
            testResource1File = this.getClasspathFile(testResource1);
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("unable to find " + testResource1));
        }
        File testResource2File = null;
        try {
            testResource2File = this.getClasspathFile(testResource2);
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("unable to find " + testResource2));
        }
        File testResource3File = null;
        try {
            testResource3File = this.getClasspathFile(testResource3);
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("unable to find " + testResource3));
        }
        ArrayList<File> testFiles = new ArrayList<File>();
        testFiles.add(testResource1File);
        testFiles.add(testResource2File);
        testFiles.add(testResource3File);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(expectedContents);
        expected.add(expectedContents2);
        expected.add(expectedContents3);
        ArrayList<Boolean> gzipped = new ArrayList<Boolean>();
        gzipped.add(false);
        gzipped.add(true);
        gzipped.add(false);
        boolean tmpFileCreated = false;
        File tmpFile = File.createTempFile("textbytearray", ".txt");
        try (FileOutputStream os = new FileOutputStream(tmpFile);){
            IOUtils.write((byte[])expectedContents.getBytes("UTF-8"), (OutputStream)os);
            tmpFileCreated = true;
            testFiles.add(tmpFile);
            expected.add(expectedContents);
            gzipped.add(false);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (!tmpFileCreated) {
            Assert.fail((String)"Unable to test ByteArrayMultiPart, as unable to write to filesystem the tmp test content");
        }
        AsyncHttpClientConfig.Builder bc = new AsyncHttpClientConfig.Builder();
        bc.setFollowRedirect(true);
        try (AsyncHttpClient client = new AsyncHttpClient(bc.build());){
            RequestBuilder builder = new RequestBuilder("POST");
            builder.setUrl(this.servletEndpointRedirectUrl + "/upload/bob");
            builder.addBodyPart((Part)new FilePart("file1", testResource1File, "text/plain", StandardCharsets.UTF_8));
            builder.addBodyPart((Part)new FilePart("file2", testResource2File, "application/x-gzip", null));
            builder.addBodyPart((Part)new StringPart("Name", "Dominic"));
            builder.addBodyPart((Part)new FilePart("file3", testResource3File, "text/plain", StandardCharsets.UTF_8));
            builder.addBodyPart((Part)new StringPart("Age", "3"));
            builder.addBodyPart((Part)new StringPart("Height", "shrimplike"));
            builder.addBodyPart((Part)new StringPart("Hair", "ridiculous"));
            builder.addBodyPart((Part)new ByteArrayPart("file4", expectedContents.getBytes(StandardCharsets.UTF_8), "text/plain", StandardCharsets.UTF_8, "bytearray.txt"));
            Request r = builder.build();
            Response res = (Response)client.executeRequest(r).get();
            Assert.assertEquals((int)200, (int)res.getStatusCode());
            this.testSentFile(expected, testFiles, res, gzipped);
        }
        finally {
            FileUtils.deleteQuietly((File)tmpFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSentFile(List<String> expectedContents, List<File> sourceFiles, Response r, List<Boolean> deflate) {
        String content = null;
        try {
            content = r.getResponseBody();
            Assert.assertNotNull((Object)("===>" + content));
            System.out.println(content);
        }
        catch (IOException e) {
            Assert.fail((String)"Unable to obtain content");
        }
        String[] contentArray = content.split("\\|\\|");
        Assert.assertEquals((int)2, (int)contentArray.length);
        String tmpFiles = contentArray[1];
        Assert.assertNotNull((Object)tmpFiles);
        Assert.assertTrue((tmpFiles.trim().length() > 2 ? 1 : 0) != 0);
        tmpFiles = tmpFiles.substring(1, tmpFiles.length() - 1);
        Object[] responseFiles = tmpFiles.split(",");
        Assert.assertNotNull((Object)responseFiles);
        Assert.assertEquals((int)sourceFiles.size(), (int)responseFiles.length);
        System.out.println(Arrays.toString(responseFiles));
        int i = 0;
        for (File sourceFile : sourceFiles) {
            FileInputStream instream;
            block16: {
                instream = null;
                File tmp = null;
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] sourceBytes = null;
                    try {
                        instream = new FileInputStream(sourceFile);
                        byte[] buf = new byte[8092];
                        int len = 0;
                        while ((len = instream.read(buf)) > 0) {
                            baos.write(buf, 0, len);
                        }
                        System.out.println("================");
                        System.out.println("Length of file: " + baos.toByteArray().length);
                        System.out.println("Contents: " + Arrays.toString(baos.toByteArray()));
                        System.out.println("================");
                        System.out.flush();
                        sourceBytes = baos.toByteArray();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(instream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)instream);
                    tmp = new File(((String)responseFiles[i]).trim());
                    System.out.println("==============================");
                    System.out.println(tmp.getAbsolutePath());
                    System.out.println("==============================");
                    System.out.flush();
                    Assert.assertTrue((boolean)tmp.exists());
                    instream = new FileInputStream(tmp);
                    ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                    byte[] buf = new byte[8092];
                    int len = 0;
                    while ((len = instream.read(buf)) > 0) {
                        baos2.write(buf, 0, len);
                    }
                    IOUtils.closeQuietly((InputStream)instream);
                    Assert.assertEquals((byte[])sourceBytes, (byte[])baos2.toByteArray());
                    if (!deflate.get(i).booleanValue()) {
                        String helloString = new String(baos2.toByteArray());
                        Assert.assertEquals((String)expectedContents.get(i), (String)helloString);
                    } else {
                        instream = new FileInputStream(tmp);
                        GZIPInputStream deflater = new GZIPInputStream(instream);
                        ByteArrayOutputStream baos3 = new ByteArrayOutputStream();
                        byte[] buf3 = new byte[8092];
                        int len3 = 0;
                        while ((len3 = deflater.read(buf3)) > 0) {
                            baos3.write(buf3, 0, len3);
                        }
                        String helloString = new String(baos3.toByteArray());
                        Assert.assertEquals((String)expectedContents.get(i), (String)helloString);
                    }
                    if (tmp == null) break block16;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)"Download Exception");
                    continue;
                }
                finally {
                    if (tmp != null) {
                        FileUtils.deleteQuietly(tmp);
                    }
                    IOUtils.closeQuietly(instream);
                    ++i;
                    continue;
                }
                FileUtils.deleteQuietly((File)tmp);
            }
            IOUtils.closeQuietly((InputStream)instream);
            ++i;
        }
    }

    public static class MockMultipartUploadServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private int filesProcessed = 0;
        private int stringsProcessed = 0;

        public synchronized void resetFilesProcessed() {
            this.filesProcessed = 0;
        }

        private synchronized int incrementFilesProcessed() {
            return ++this.filesProcessed;
        }

        public int getFilesProcessed() {
            return this.filesProcessed;
        }

        public synchronized void resetStringsProcessed() {
            this.stringsProcessed = 0;
        }

        private synchronized int incrementStringsProcessed() {
            return ++this.stringsProcessed;
        }

        public int getStringsProcessed() {
            return this.stringsProcessed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            if (isMultipart) {
                ArrayList<String> files = new ArrayList<String>();
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iter = null;
                try {
                    iter = upload.getItemIterator(request);
                    while (iter.hasNext()) {
                        FileItemStream item = iter.next();
                        String name = item.getFieldName();
                        InputStream stream = null;
                        try {
                            stream = item.openStream();
                            if (item.isFormField()) {
                                System.out.println("Form field " + name + " with value " + Streams.asString((InputStream)stream) + " detected.");
                                this.incrementStringsProcessed();
                                continue;
                            }
                            System.out.println("File field " + name + " with file name " + item.getName() + " detected.");
                            FileOutputStream os = null;
                            try {
                                int bytesRead;
                                File tmpFile = File.createTempFile(UUID.randomUUID().toString() + "_MockUploadServlet", ".tmp");
                                tmpFile.deleteOnExit();
                                os = new FileOutputStream(tmpFile);
                                byte[] buffer = new byte[4096];
                                while ((bytesRead = stream.read(buffer)) != -1) {
                                    ((OutputStream)os).write(buffer, 0, bytesRead);
                                }
                                this.incrementFilesProcessed();
                                files.add(tmpFile.getAbsolutePath());
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(os);
                                throw throwable;
                            }
                            IOUtils.closeQuietly((OutputStream)os);
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)stream);
                        }
                    }
                }
                catch (FileUploadException item) {
                    // empty catch block
                }
                PrintWriter w = response.getWriter();
                ((Writer)w).write(Integer.toString(this.getFilesProcessed()));
                this.resetFilesProcessed();
                this.resetStringsProcessed();
                ((Writer)w).write("||");
                ((Writer)w).write(((Object)files).toString());
                ((Writer)w).close();
            } else {
                PrintWriter w = response.getWriter();
                ((Writer)w).write(Integer.toString(this.getFilesProcessed()));
                this.resetFilesProcessed();
                this.resetStringsProcessed();
                ((Writer)w).write("||");
                ((Writer)w).close();
            }
        }
    }
}

