/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class NTLMProxyTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new NTLMProxyHandler();
    }

    @Test
    public void ntlmProxyTest() throws IOException, InterruptedException, ExecutionException {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            Request request = new RequestBuilder("GET").setProxyServer(this.ntlmProxy()).setUrl(this.getTargetUrl()).build();
            ListenableFuture responseFuture = client.executeRequest(request);
            int status = ((Response)responseFuture.get()).getStatusCode();
            Assert.assertEquals((int)status, (int)200);
        }
    }

    private ProxyServer ntlmProxy() throws UnknownHostException {
        ProxyServer proxyServer = new ProxyServer("127.0.0.1", this.port2, "Zaphod", "Beeblebrox").setNtlmDomain("Ursa-Minor");
        proxyServer.setNtlmHost("LightCity");
        proxyServer.setScheme(Realm.AuthScheme.NTLM);
        return proxyServer;
    }

    public static class NTLMProxyHandler
    extends HandlerWrapper {
        public void handle(String pathInContext, org.eclipse.jetty.server.Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            String authorization = httpRequest.getHeader("Proxy-Authorization");
            if (authorization == null) {
                httpResponse.setStatus(407);
                httpResponse.setHeader("Proxy-Authenticate", "NTLM");
            } else if (authorization.equals("NTLM TlRMTVNTUAABAAAAAYIIogAAAAAoAAAAAAAAACgAAAAFASgKAAAADw==")) {
                httpResponse.setStatus(407);
                httpResponse.setHeader("Proxy-Authenticate", "NTLM TlRMTVNTUAACAAAAAAAAACgAAAABggAAU3J2Tm9uY2UAAAAAAAAAAA==");
            } else if (authorization.equals("NTLM TlRMTVNTUAADAAAAGAAYAEgAAAAYABgAYAAAABQAFAB4AAAADAAMAIwAAAASABIAmAAAAAAAAACqAAAAAYIAAgUBKAoAAAAPrYfKbe/jRoW5xDxHeoxC1gBmfWiS5+iX4OAN4xBKG/IFPwfH3agtPEia6YnhsADTVQBSAFMAQQAtAE0ASQBOAE8AUgBaAGEAcABoAG8AZABMAGkAZwBoAHQAQwBpAHQAeQA=")) {
                httpResponse.setStatus(200);
            } else {
                httpResponse.setStatus(401);
            }
            httpResponse.setContentLength(0);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

