/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.async.ProviderUtil;
import com.ning.http.client.providers.grizzly.GrizzlyResponseFuture;
import com.ning.http.client.providers.grizzly.HttpTransactionContext;
import java.util.Map;
import org.mockito.Mockito;
import org.slf4j.MDC;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GrizzlyAsyncHttpProviderTest
extends AbstractBasicTest {
    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncProviderPreservesClassLoader() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Request request = new RequestBuilder("GET").setUrl(this.getTargetUrl() + "?q=+%20x").build();
            AsyncCompletionHandler<String> asyncCompletionHandler = new AsyncCompletionHandler<String>(){

                public String onCompleted(Response response) throws Exception {
                    return response.getUri().toString();
                }

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                    Assert.fail((String)("Unexpected exception: " + t.getMessage()), (Throwable)t);
                }
            };
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader mockClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
            Thread.currentThread().setContextClassLoader(mockClassLoader);
            ListenableFuture responseFuture = client.executeRequest(request, (AsyncHandler)asyncCompletionHandler);
            Thread.currentThread().setContextClassLoader(currentClassLoader);
            responseFuture.get();
            GrizzlyResponseFuture grizzlyResponseFuture = (GrizzlyResponseFuture)responseFuture;
            HttpTransactionContext transactionContext = grizzlyResponseFuture.getHttpTransactionCtx();
            Assert.assertEquals((Object)transactionContext.getConnection().getAttributes().getAttribute("classLoader"), (Object)mockClassLoader);
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncProviderPreservesEntriesInTheMDC() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Request request = new RequestBuilder("GET").setUrl(this.getTargetUrl() + "?q=+%20x").build();
            AsyncCompletionHandler<String> asyncCompletionHandler = new AsyncCompletionHandler<String>(){

                public String onCompleted(Response response) throws Exception {
                    return response.getUri().toString();
                }

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                    Assert.fail((String)("Unexpected exception: " + t.getMessage()), (Throwable)t);
                }
            };
            MDC.put((String)"theKey", (String)"theValue");
            ListenableFuture responseFuture = client.executeRequest(request, (AsyncHandler)asyncCompletionHandler);
            MDC.remove((String)"theKey");
            responseFuture.get();
            GrizzlyResponseFuture grizzlyResponseFuture = (GrizzlyResponseFuture)responseFuture;
            HttpTransactionContext transactionContext = grizzlyResponseFuture.getHttpTransactionCtx();
            Map mdc = (Map)transactionContext.getConnection().getAttributes().getAttribute("mdc");
            Assert.assertEquals((String)((String)mdc.get("theKey")), (String)"theValue");
        }
    }

    @Override
    public AsyncHttpClient getAsyncHttpClient(AsyncHttpClientConfig config) {
        return ProviderUtil.grizzlyProvider(config);
    }
}

