/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class BasicHttpProxyToHttpTest
extends AbstractBasicTest {
    private Server server2;

    @Override
    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        this.server.stop();
        this.server2.stop();
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        this.server2 = new Server();
        this.port1 = this.findFreePort();
        this.port2 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        this.server.setHandler((Handler)new AbstractBasicTest.EchoHandler());
        this.server.start();
        listener = new ServerConnector(this.server2);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port2);
        this.server2.addConnector((Connector)listener);
        this.server2.setHandler((Handler)this.configureHandler());
        this.server2.start();
        this.log.info("Local HTTP Server (" + this.port1 + "), Proxy HTTP Server (" + this.port2 + ") started successfully");
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new ProxyHTTPHandler();
    }

    @Test
    public void httpProxyToHttpTargetUsePreemptiveAuthTest() throws IOException, InterruptedException, ExecutionException {
        this.doTest(true);
    }

    @Test
    public void httpProxyToHttpTargetTest() throws IOException, InterruptedException, ExecutionException {
        this.doTest(false);
    }

    private void doTest(boolean usePreemptiveAuth) throws UnknownHostException, InterruptedException, ExecutionException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().build());){
            Request request = ((RequestBuilder)new RequestBuilder("GET").setProxyServer(this.basicProxy()).setUrl(this.getTargetUrl()).setRealm(new Realm.RealmBuilder().setPrincipal("user").setPassword("passwd").setScheme(Realm.AuthScheme.BASIC).setUsePreemptiveAuth(usePreemptiveAuth).build())).build();
            ListenableFuture responseFuture = client.executeRequest(request);
            Response response = (Response)responseFuture.get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertTrue((boolean)this.getTargetUrl().endsWith(response.getHeader("target")));
        }
    }

    private ProxyServer basicProxy() throws UnknownHostException {
        ProxyServer proxyServer = new ProxyServer("127.0.0.1", this.port2, "johndoe", "pass");
        proxyServer.setScheme(Realm.AuthScheme.BASIC);
        return proxyServer;
    }

    public static class ProxyHTTPHandler
    extends AbstractHandler {
        public void handle(String pathInContext, org.eclipse.jetty.server.Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            String authorization = httpRequest.getHeader("Authorization");
            String proxyAuthorization = httpRequest.getHeader("Proxy-Authorization");
            if (proxyAuthorization == null) {
                httpResponse.setStatus(407);
                httpResponse.setHeader("Proxy-Authenticate", "Basic realm=\"Fake Realm\"");
            } else if (proxyAuthorization.equals("Basic am9obmRvZTpwYXNz") && authorization != null && authorization.equals("Basic dXNlcjpwYXNzd2Q=")) {
                httpResponse.addHeader("target", request.getHttpURI().getPath());
                httpResponse.setStatus(200);
            } else {
                httpResponse.setStatus(401);
                httpResponse.setHeader("www-authenticate", "Basic realm=\"Fake Realm\"");
            }
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
            request.setHandled(true);
        }
    }
}

